/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateObjectValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractDateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEarlierThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.DateObjectLaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ITimeZone;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.LongDateFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ServerTimeZone;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFieldSearchCriteriaTranslator
extends AbstractFieldSearchCriteriaTranslator {
    public DateFieldSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof DateFieldSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        DateFieldSearchCriteria dateCriteria = (DateFieldSearchCriteria)criteria;
        DetailedSearchField detailedSearchField = this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)dateCriteria);
        CompareType compareType = this.getCompareType((IDate)dateCriteria.getFieldValue());
        String value = this.getValue((IDate)dateCriteria.getFieldValue());
        String timeZone = this.getTimeZone((IDate)dateCriteria.getFieldValue(), dateCriteria.getTimeZone());
        return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(detailedSearchField, compareType, value, timeZone));
    }

    private CompareType getCompareType(IDate value) {
        if (value instanceof DateObjectEqualToValue || value instanceof DateEqualToValue) {
            return CompareType.EQUALS;
        }
        if (value instanceof DateObjectEarlierThanOrEqualToValue || value instanceof DateEarlierThanOrEqualToValue) {
            return CompareType.LESS_THAN_OR_EQUAL;
        }
        if (value instanceof DateObjectLaterThanOrEqualToValue || value instanceof DateLaterThanOrEqualToValue) {
            return CompareType.MORE_THAN_OR_EQUAL;
        }
        throw new IllegalArgumentException("Unknown date field value: " + value);
    }

    private String getValue(IDate value) {
        if (value instanceof AbstractDateValue) {
            return (String)((AbstractDateValue)value).getValue();
        }
        if (value instanceof AbstractDateObjectValue) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(new LongDateFormat().getFormat());
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat.format((Date)((AbstractDateObjectValue)value).getValue());
        }
        throw new IllegalArgumentException("Unknown date field value: " + value);
    }

    private String getTimeZone(IDate value, ITimeZone timeZone) {
        if (value instanceof AbstractDateValue) {
            if (timeZone instanceof ServerTimeZone) {
                return "server";
            }
            if (timeZone instanceof ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone) {
                return String.valueOf(((ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TimeZone)timeZone).getHourOffset());
            }
            throw new IllegalArgumentException("Unknown date field time zone: " + timeZone);
        }
        return String.valueOf(0);
    }
}

