/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.EnumFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import java.util.Map;

public class EnumFieldSearchCriteriaTranslator
extends AbstractFieldSearchCriteriaTranslator {
    public EnumFieldSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof EnumFieldSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        EnumFieldSearchCriteria stringCriteria = (EnumFieldSearchCriteria)criteria;
        if (stringCriteria.getFieldValue() == null) {
            throw new IllegalArgumentException("Unspecified value of criteria '" + criteria + "'.");
        }
        Enum enumValue = (Enum)stringCriteria.getFieldValue();
        Map<Enum<?>, String> mapping = this.getValueToIndexedValueMapping();
        String stringValue = enumValue.name();
        if (mapping != null) {
            if (mapping.containsKey(enumValue)) {
                stringValue = mapping.get(enumValue);
            } else {
                throw new IllegalArgumentException("Could not map value '" + enumValue + "' to indexed value.");
            }
        }
        return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), stringValue));
    }

    protected Map<? extends Enum<?>, String> getValueToIndexedValueMapping() {
        return null;
    }
}

