/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractNumberValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NumberLessThanValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;

public class NumberFieldSearchCriteriaTranslator
extends AbstractFieldSearchCriteriaTranslator {
    public NumberFieldSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof NumberFieldSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        NumberFieldSearchCriteria numberCriteria = (NumberFieldSearchCriteria)criteria;
        AbstractNumberValue valueObject = (AbstractNumberValue)numberCriteria.getFieldValue();
        if (valueObject instanceof NumberLessThanValue) {
            NumberLessThanValue lessToValue = (NumberLessThanValue)valueObject;
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)numberCriteria), CompareType.LESS_THAN, (Number)lessToValue.getValue()));
        }
        if (valueObject instanceof NumberLessThanOrEqualToValue) {
            NumberLessThanOrEqualToValue lessOrEqualToValue = (NumberLessThanOrEqualToValue)valueObject;
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)numberCriteria), CompareType.LESS_THAN_OR_EQUAL, (Number)lessOrEqualToValue.getValue()));
        }
        if (valueObject instanceof NumberEqualToValue) {
            NumberEqualToValue equalToValue = (NumberEqualToValue)valueObject;
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)numberCriteria), CompareType.EQUALS, (Number)equalToValue.getValue()));
        }
        if (valueObject instanceof NumberGreaterThanOrEqualToValue) {
            NumberGreaterThanOrEqualToValue greaterOrEqualToValue = (NumberGreaterThanOrEqualToValue)valueObject;
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)numberCriteria), CompareType.MORE_THAN_OR_EQUAL, (Number)greaterOrEqualToValue.getValue()));
        }
        if (valueObject instanceof NumberGreaterThanValue) {
            NumberGreaterThanValue greaterToValue = (NumberGreaterThanValue)valueObject;
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)numberCriteria), CompareType.MORE_THAN, (Number)greaterToValue.getValue()));
        }
        throw new IllegalArgumentException("Unknown number field value: " + valueObject);
    }
}

