/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AnyStringValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringContainsValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEndsWithValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringFieldSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringGreaterThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanOrEqualToValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringLessThanValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.StringStartsWithValue;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;

public class StringFieldSearchCriteriaTranslator
extends AbstractFieldSearchCriteriaTranslator {
    public StringFieldSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof StringFieldSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        String value;
        StringFieldSearchCriteria stringCriteria = (StringFieldSearchCriteria)criteria;
        AbstractStringValue valueObject = (AbstractStringValue)stringCriteria.getFieldValue();
        if (valueObject instanceof StringEqualToValue) {
            StringEqualToValue equalToValue = (StringEqualToValue)valueObject;
            value = (String)equalToValue.getValue();
        } else {
            if (valueObject instanceof StringLessThanValue) {
                StringLessThanValue lessToValue = (StringLessThanValue)valueObject;
                return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), CompareType.LESS_THAN, (String)lessToValue.getValue()));
            }
            if (valueObject instanceof StringLessThanOrEqualToValue) {
                StringLessThanOrEqualToValue lessOrEqualToValue = (StringLessThanOrEqualToValue)valueObject;
                return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), CompareType.LESS_THAN_OR_EQUAL, (String)lessOrEqualToValue.getValue()));
            }
            if (valueObject instanceof StringGreaterThanOrEqualToValue) {
                StringGreaterThanOrEqualToValue greaterOrEqualToValue = (StringGreaterThanOrEqualToValue)valueObject;
                return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), CompareType.MORE_THAN_OR_EQUAL, (String)greaterOrEqualToValue.getValue()));
            }
            if (valueObject instanceof StringGreaterThanValue) {
                StringGreaterThanValue greaterToValue = (StringGreaterThanValue)valueObject;
                return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), CompareType.MORE_THAN, (String)greaterToValue.getValue()));
            }
            if (valueObject instanceof StringStartsWithValue) {
                StringStartsWithValue startsWithValue = (StringStartsWithValue)valueObject;
                value = (String)startsWithValue.getValue() + "*";
            } else if (valueObject instanceof StringEndsWithValue) {
                StringEndsWithValue endsWithValue = (StringEndsWithValue)valueObject;
                value = "*" + (String)endsWithValue.getValue();
            } else if (valueObject instanceof StringContainsValue) {
                StringContainsValue endsWithValue = (StringContainsValue)valueObject;
                value = "*" + (String)endsWithValue.getValue() + "*";
            } else if (valueObject instanceof AnyStringValue) {
                value = "*";
            } else {
                if (valueObject != null) {
                    throw new IllegalArgumentException("Unknown string field value: " + valueObject);
                }
                throw new IllegalArgumentException("Unspecified value of criteria '" + criteria + "'.");
            }
        }
        return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(this.getDetailedSearchField(context, (AbstractFieldSearchCriteria<?>)stringCriteria), value));
    }
}

