/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.history.DataSetRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.ContentCopyHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.IRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.id.UnknownRelatedObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryContentCopyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSetHistoryTranslator
extends HistoryTranslator
implements IDataSetHistoryTranslator {
    @Autowired
    private IExperimentAuthorizationValidator experimentValidator;
    @Autowired
    private ISampleAuthorizationValidator sampleValidator;
    @Autowired
    private IDataSetAuthorizationValidator dataSetValidator;

    @Override
    protected List<? extends PropertyRecord> loadProperties(Collection<Long> entityIds) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        return query.getProperties((LongSet)new LongOpenHashSet(entityIds));
    }

    protected List<HistoryPropertyRecord> loadPropertyHistory(Collection<Long> entityIds) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        return query.getPropertiesHistory((LongSet)new LongOpenHashSet(entityIds));
    }

    @Override
    protected List<? extends HistoryRelationshipRecord> loadRelationshipHistory(TranslationContext context, Collection<Long> entityIds) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        List<DataSetRelationshipRecord> records = query.getRelationshipsHistory((LongSet)new LongOpenHashSet(entityIds));
        ArrayList<DataSetRelationshipRecord> validRecords = new ArrayList<DataSetRelationshipRecord>();
        Set<Long> experimentIds = new HashSet<Long>();
        Set<Long> sampleIds = new HashSet<Long>();
        Set<Long> dataSetIds = new HashSet<Long>();
        for (DataSetRelationshipRecord record : records) {
            if (record.experimentId != null) {
                experimentIds.add(record.experimentId);
                continue;
            }
            if (record.sampleId != null) {
                sampleIds.add(record.sampleId);
                continue;
            }
            if (record.dataSetId == null) continue;
            dataSetIds.add(record.dataSetId);
        }
        if (!experimentIds.isEmpty()) {
            experimentIds = this.experimentValidator.validate(context.getSession().tryGetPerson(), experimentIds);
        }
        if (!sampleIds.isEmpty()) {
            sampleIds = this.sampleValidator.validate(context.getSession().tryGetPerson(), sampleIds);
        }
        if (!dataSetIds.isEmpty()) {
            dataSetIds = this.dataSetValidator.validate(context.getSession().tryGetPerson(), dataSetIds);
        }
        boolean isSystemUser = context.getSession().tryGetPerson() != null && context.getSession().tryGetPerson().isSystemUser();
        for (DataSetRelationshipRecord record : records) {
            boolean isValid = false;
            isValid = record.experimentId != null ? experimentIds.contains(record.experimentId) : (record.sampleId != null ? sampleIds.contains(record.sampleId) : (record.dataSetId != null ? dataSetIds.contains(record.dataSetId) : isSystemUser));
            if (!isValid) continue;
            validRecords.add(record);
        }
        return validRecords;
    }

    @Override
    protected RelationHistoryEntry createRelationshipEntry(HistoryRelationshipRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        RelationHistoryEntry entry = super.createRelationshipEntry(record, authorMap, fetchOptions);
        DataSetRelationshipRecord dataSetRecord = (DataSetRelationshipRecord)record;
        if (this.isExperiment(dataSetRecord)) {
            entry.setRelationType((IRelationType)DataSetRelationType.EXPERIMENT);
            entry.setRelatedObjectId((IObjectId)new ExperimentPermId(dataSetRecord.relatedObjectId));
        } else if (this.isSample(dataSetRecord)) {
            entry.setRelationType((IRelationType)DataSetRelationType.SAMPLE);
            entry.setRelatedObjectId((IObjectId)new SamplePermId(dataSetRecord.relatedObjectId));
        } else if (this.isDataSet(dataSetRecord)) {
            RelationType relationType = RelationType.valueOf(dataSetRecord.relationType);
            switch (relationType) {
                case PARENT: {
                    entry.setRelationType((IRelationType)DataSetRelationType.CHILD);
                    break;
                }
                case CHILD: {
                    entry.setRelationType((IRelationType)DataSetRelationType.PARENT);
                    break;
                }
                case CONTAINER: {
                    entry.setRelationType((IRelationType)DataSetRelationType.COMPONENT);
                    break;
                }
                case CONTAINED: 
                case COMPONENT: {
                    entry.setRelationType((IRelationType)DataSetRelationType.CONTAINER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported relation type: " + (Object)((Object)relationType));
                }
            }
            entry.setRelatedObjectId((IObjectId)new DataSetPermId(dataSetRecord.relatedObjectId));
        } else {
            entry.setRelatedObjectId((IObjectId)new UnknownRelatedObjectId(dataSetRecord.relatedObjectId, dataSetRecord.relationType));
        }
        return entry;
    }

    @Override
    protected List<? extends HistoryRecord> loadAbritraryHistory(TranslationContext context, Collection<Long> entityIds) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        return query.getContentCopyHistory((LongSet)new LongOpenHashSet(entityIds));
    }

    @Override
    protected void createArbitraryEntries(Map<Long, List<HistoryEntry>> entriesMap, List<? extends HistoryRecord> records, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        ArrayList<? extends HistoryRecord> sortedRecords = new ArrayList<HistoryRecord>(records);
        sortedRecords.sort(Comparator.comparing(HistoryRecord::getValidFrom).thenComparing(HistoryRecord::getValidTo, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ObjectBaseRecord::getId));
        for (HistoryRecord historyRecord : sortedRecords) {
            HistoryContentCopyRecord contentCopyRecord = (HistoryContentCopyRecord)historyRecord;
            List<HistoryEntry> entries = entriesMap.get(contentCopyRecord.dataSetId);
            if (entries == null) {
                entries = new LinkedList<HistoryEntry>();
                entriesMap.put(contentCopyRecord.dataSetId, entries);
            }
            entries.add(this.createContentCopyEntry(historyRecord, authorMap, fetchOptions));
        }
    }

    private HistoryEntry createContentCopyEntry(HistoryRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        HistoryContentCopyRecord contentCopyRecord = (HistoryContentCopyRecord)record;
        ContentCopyHistoryEntry entry = new ContentCopyHistoryEntry();
        entry.setFetchOptions(new HistoryEntryFetchOptions());
        entry.setExternalCode(contentCopyRecord.externalCode);
        entry.setPath(contentCopyRecord.path);
        entry.setGitCommitHash(contentCopyRecord.gitCommitHash);
        entry.setGitRepositoryId(contentCopyRecord.gitRepositoryId);
        entry.setExternalDmsId(contentCopyRecord.externalDmsId);
        entry.setExternalDmsCode(contentCopyRecord.externalDmsCode);
        entry.setExternalDmsLabel(contentCopyRecord.externalDmsLabel);
        entry.setExternalDmsAddress(contentCopyRecord.externalDmsAddress);
        entry.setValidFrom(contentCopyRecord.validFrom);
        entry.setValidTo(contentCopyRecord.validTo);
        if (fetchOptions.hasAuthor()) {
            entry.setAuthor(authorMap.get(record.authorId));
            entry.getFetchOptions().withAuthorUsing(fetchOptions.withAuthor());
        }
        return entry;
    }
}

