/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.EmptyFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetPostRegisteredTranslator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.lemnik.eodsql.QueryTool;
import org.springframework.stereotype.Component;

@Component
public class DataSetPostRegisteredTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<Boolean>, EmptyFetchOptions>
implements IDataSetPostRegisteredTranslator {
    @Override
    protected ObjectHolder<Boolean> createObject(TranslationContext context, Long input, EmptyFetchOptions fetchOptions) {
        return new ObjectHolder<Boolean>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> dataSetIds, EmptyFetchOptions fetchOptions) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        HashSet<Long> notPostregisteredDataSets = new HashSet<Long>(query.getNotPostRegisteredDataSets((LongSet)new LongOpenHashSet(dataSetIds)));
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        for (Long dataSetId : dataSetIds) {
            map.put(dataSetId, !notPostregisteredDataSets.contains(dataSetId));
        }
        return map;
    }

    @Override
    protected void updateObject(TranslationContext context, Long dataSetId, ObjectHolder<Boolean> output, Object relations, EmptyFetchOptions fetchOptions) {
        Map entriesMap = (Map)relations;
        output.setObject((Boolean)entriesMap.get(dataSetId));
    }
}

