/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.PhysicalData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.DataStore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetChildTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetComponentsTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetContainerTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetDataStoreTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetLinkedDataTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetModifierTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetParentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetPhysicalDataTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetPostRegisteredTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetSamplePropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetSampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTagTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTypeRelationTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSetTranslator
extends AbstractCachingTranslator<Long, DataSet, DataSetFetchOptions>
implements IDataSetTranslator {
    @Autowired
    private IDataSetAuthorizationValidator authorizationValidator;
    @Autowired
    private IDataSetBaseTranslator baseTranslator;
    @Autowired
    private IDataSetTypeRelationTranslator typeTranslator;
    @Autowired
    private IDataSetPropertyTranslator propertyTranslator;
    @Autowired
    private IDataSetMaterialPropertyTranslator materialPropertyTranslator;
    @Autowired
    private IDataSetSamplePropertyTranslator samplePropertyTranslator;
    @Autowired
    private IDataSetPhysicalDataTranslator physicalDataTranslator;
    @Autowired
    private IDataSetLinkedDataTranslator linkedDataTranslator;
    @Autowired
    private IDataSetDataStoreTranslator dataStoreTranslator;
    @Autowired
    private IDataSetSampleTranslator sampleTranslator;
    @Autowired
    private IDataSetExperimentTranslator experimentTranslator;
    @Autowired
    private IDataSetParentTranslator parentTranslator;
    @Autowired
    private IDataSetChildTranslator childTranslator;
    @Autowired
    private IDataSetContainerTranslator containerTranslator;
    @Autowired
    private IDataSetComponentsTranslator componentsTranslator;
    @Autowired
    private IDataSetTagTranslator tagTranslator;
    @Autowired
    private IDataSetHistoryTranslator historyTranslator;
    @Autowired
    private IDataSetRegistratorTranslator registratorTranslator;
    @Autowired
    private IDataSetModifierTranslator modifierTranslator;
    @Autowired
    private IDataSetPostRegisteredTranslator postRegisteredTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> dataSetIds, DataSetFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), dataSetIds);
    }

    @Override
    protected DataSet createObject(TranslationContext context, Long dataSetId, DataSetFetchOptions fetchOptions) {
        DataSet dataSet = new DataSet();
        dataSet.setFetchOptions(new DataSetFetchOptions());
        return dataSet;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> dataSetIds, DataSetFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IDataSetBaseTranslator.class, this.baseTranslator.translate(context, dataSetIds, null));
        relations.put(IDataSetPostRegisteredTranslator.class, this.postRegisteredTranslator.translate(context, dataSetIds, null));
        if (fetchOptions.hasType()) {
            relations.put(IDataSetTypeRelationTranslator.class, this.typeTranslator.translate(context, dataSetIds, fetchOptions.withType()));
        }
        if (fetchOptions.hasProperties()) {
            relations.put(IDataSetPropertyTranslator.class, this.propertyTranslator.translate(context, dataSetIds, fetchOptions.withProperties()));
        }
        if (fetchOptions.hasMaterialProperties()) {
            relations.put(IDataSetMaterialPropertyTranslator.class, this.materialPropertyTranslator.translate(context, dataSetIds, fetchOptions.withMaterialProperties()));
        }
        if (fetchOptions.hasSampleProperties()) {
            relations.put(IDataSetSamplePropertyTranslator.class, this.samplePropertyTranslator.translate(context, dataSetIds, fetchOptions.withSampleProperties()));
        }
        if (fetchOptions.hasPhysicalData()) {
            relations.put(IDataSetPhysicalDataTranslator.class, this.physicalDataTranslator.translate(context, dataSetIds, fetchOptions.withPhysicalData()));
        }
        if (fetchOptions.hasLinkedData()) {
            relations.put(IDataSetLinkedDataTranslator.class, this.linkedDataTranslator.translate(context, dataSetIds, fetchOptions.withLinkedData()));
        }
        if (fetchOptions.hasDataStore()) {
            relations.put(IDataSetDataStoreTranslator.class, this.dataStoreTranslator.translate(context, dataSetIds, fetchOptions.withDataStore()));
        }
        if (fetchOptions.hasSample()) {
            relations.put(IDataSetSampleTranslator.class, this.sampleTranslator.translate(context, dataSetIds, fetchOptions.withSample()));
        }
        if (fetchOptions.hasExperiment()) {
            relations.put(IDataSetExperimentTranslator.class, this.experimentTranslator.translate(context, dataSetIds, fetchOptions.withExperiment()));
        }
        if (fetchOptions.hasContainers()) {
            relations.put(IDataSetContainerTranslator.class, this.containerTranslator.translate(context, dataSetIds, fetchOptions.withContainers()));
        }
        if (fetchOptions.hasComponents()) {
            relations.put(IDataSetComponentsTranslator.class, this.componentsTranslator.translate(context, dataSetIds, fetchOptions.withComponents()));
        }
        if (fetchOptions.hasParents()) {
            relations.put(IDataSetParentTranslator.class, this.parentTranslator.translate(context, dataSetIds, fetchOptions.withParents()));
        }
        if (fetchOptions.hasChildren()) {
            relations.put(IDataSetChildTranslator.class, this.childTranslator.translate(context, dataSetIds, fetchOptions.withChildren()));
        }
        if (fetchOptions.hasTags()) {
            relations.put(IDataSetTagTranslator.class, this.tagTranslator.translate(context, dataSetIds, fetchOptions.withTags()));
        }
        if (fetchOptions.hasHistory()) {
            relations.put(IDataSetHistoryTranslator.class, this.historyTranslator.translate(context, dataSetIds, fetchOptions.withHistory()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IDataSetRegistratorTranslator.class, this.registratorTranslator.translate(context, dataSetIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasModifier()) {
            relations.put(IDataSetModifierTranslator.class, this.modifierTranslator.translate(context, dataSetIds, fetchOptions.withModifier()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long dataSetId, DataSet result, Object objectRelations, DataSetFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        DataSetBaseRecord baseRecord = (DataSetBaseRecord)relations.get(IDataSetBaseTranslator.class, dataSetId);
        result.setPermId(new DataSetPermId(baseRecord.code));
        result.setCode(baseRecord.code);
        result.setMeasured(Boolean.valueOf(baseRecord.isDerived == false));
        result.setDataProducer(baseRecord.dataProducer);
        result.setDataProductionDate(baseRecord.dataProductionDate);
        result.setAccessDate(baseRecord.accessDate);
        result.setModificationDate(baseRecord.modificationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setPostRegistered((Boolean)relations.get(IDataSetPostRegisteredTranslator.class, dataSetId));
        result.setKind(DataSetKind.valueOf((String)baseRecord.dataSetKind));
        result.setFrozen(baseRecord.frozen);
        result.setFrozenForChildren(baseRecord.frozenForChildren);
        result.setFrozenForParents(baseRecord.frozenForParents);
        result.setFrozenForComponents(baseRecord.frozenForComponents);
        result.setFrozenForContainers(baseRecord.frozenForContainers);
        if (fetchOptions.hasType()) {
            result.setType((DataSetType)relations.get(IDataSetTypeRelationTranslator.class, dataSetId));
            result.getFetchOptions().withTypeUsing(fetchOptions.withType());
        }
        if (fetchOptions.hasProperties()) {
            result.setProperties((Map)relations.get(IDataSetPropertyTranslator.class, dataSetId));
            result.getFetchOptions().withPropertiesUsing(fetchOptions.withProperties());
        }
        if (fetchOptions.hasMaterialProperties()) {
            result.setMaterialProperties((Map)relations.get(IDataSetMaterialPropertyTranslator.class, dataSetId));
            result.getFetchOptions().withMaterialPropertiesUsing(fetchOptions.withMaterialProperties());
        }
        if (fetchOptions.hasSampleProperties()) {
            result.setSampleProperties((Map)relations.get(IDataSetSamplePropertyTranslator.class, dataSetId));
            result.getFetchOptions().withSamplePropertiesUsing(fetchOptions.withSampleProperties());
        }
        if (fetchOptions.hasPhysicalData()) {
            result.setPhysicalData((PhysicalData)relations.get(IDataSetPhysicalDataTranslator.class, dataSetId));
            result.getFetchOptions().withPhysicalDataUsing(fetchOptions.withPhysicalData());
        }
        if (fetchOptions.hasLinkedData()) {
            result.setLinkedData((LinkedData)relations.get(IDataSetLinkedDataTranslator.class, dataSetId));
            result.getFetchOptions().withLinkedDataUsing(fetchOptions.withLinkedData());
        }
        if (fetchOptions.hasDataStore()) {
            result.setDataStore((DataStore)relations.get(IDataSetDataStoreTranslator.class, dataSetId));
            result.getFetchOptions().withDataStoreUsing(fetchOptions.withDataStore());
        }
        if (fetchOptions.hasSample()) {
            result.setSample((Sample)relations.get(IDataSetSampleTranslator.class, dataSetId));
            result.getFetchOptions().withSampleUsing(fetchOptions.withSample());
        }
        if (fetchOptions.hasExperiment()) {
            result.setExperiment((Experiment)relations.get(IDataSetExperimentTranslator.class, dataSetId));
            result.getFetchOptions().withExperimentUsing(fetchOptions.withExperiment());
        }
        if (fetchOptions.hasContainers()) {
            result.setContainers((List)relations.get(IDataSetContainerTranslator.class, dataSetId));
            result.getFetchOptions().withContainersUsing(fetchOptions.withContainers());
        }
        if (fetchOptions.hasComponents()) {
            result.setComponents((List)relations.get(IDataSetComponentsTranslator.class, dataSetId));
            result.getFetchOptions().withComponentsUsing(fetchOptions.withComponents());
        }
        if (fetchOptions.hasParents()) {
            result.setParents((List)relations.get(IDataSetParentTranslator.class, dataSetId));
            result.getFetchOptions().withParentsUsing(fetchOptions.withParents());
        }
        if (fetchOptions.hasChildren()) {
            result.setChildren((List)relations.get(IDataSetChildTranslator.class, dataSetId));
            result.getFetchOptions().withChildrenUsing(fetchOptions.withChildren());
        }
        if (fetchOptions.hasTags()) {
            result.setTags((Set)relations.get(IDataSetTagTranslator.class, dataSetId));
            result.getFetchOptions().withTagsUsing(fetchOptions.withTags());
        }
        if (fetchOptions.hasHistory()) {
            result.setHistory((List)relations.get(IDataSetHistoryTranslator.class, dataSetId));
            result.getFetchOptions().withHistoryUsing(fetchOptions.withHistory());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IDataSetRegistratorTranslator.class, dataSetId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasModifier()) {
            result.setModifier((Person)relations.get(IDataSetModifierTranslator.class, dataSetId));
            result.getFetchOptions().withModifierUsing(fetchOptions.withModifier());
        }
    }
}

