/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetTypeBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetPropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTypeBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTypeValidationPluginTranslator;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSetTypeTranslator
extends AbstractCachingTranslator<Long, DataSetType, DataSetTypeFetchOptions>
implements IDataSetTypeTranslator {
    @Autowired
    private IDataSetTypeBaseTranslator baseTranslator;
    @Autowired
    private IDataSetPropertyAssignmentTranslator assignmentTranslator;
    @Autowired
    private IDataSetTypeValidationPluginTranslator validationPluginTranslator;

    @Override
    protected DataSetType createObject(TranslationContext context, Long typeId, DataSetTypeFetchOptions fetchOptions) {
        DataSetType type = new DataSetType();
        type.setFetchOptions(fetchOptions);
        return type;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> typeIds, DataSetTypeFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IDataSetTypeBaseTranslator.class, this.baseTranslator.translate(context, typeIds, null));
        if (fetchOptions.hasPropertyAssignments()) {
            relations.put(IDataSetPropertyAssignmentTranslator.class, this.assignmentTranslator.translate(context, typeIds, fetchOptions.withPropertyAssignments()));
        }
        if (fetchOptions.hasValidationPlugin()) {
            relations.put(IDataSetTypeValidationPluginTranslator.class, this.validationPluginTranslator.translate(context, typeIds, fetchOptions.withValidationPlugin()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long typeId, DataSetType result, Object objectRelations, DataSetTypeFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        DataSetTypeBaseRecord baseRecord = (DataSetTypeBaseRecord)relations.get(IDataSetTypeBaseTranslator.class, typeId);
        result.setPermId(new EntityTypePermId(baseRecord.code, EntityKind.DATA_SET));
        result.setCode(baseRecord.code);
        result.setMainDataSetPattern(baseRecord.mainDataSetPattern);
        result.setMainDataSetPath(baseRecord.mainDataSetPath);
        result.setDisallowDeletion(baseRecord.disallowDeletion);
        result.setDescription(baseRecord.description);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasPropertyAssignments()) {
            result.setPropertyAssignments((List)relations.get(IDataSetPropertyAssignmentTranslator.class, typeId));
        }
        if (fetchOptions.hasValidationPlugin()) {
            result.setValidationPlugin((Plugin)relations.get(IDataSetTypeValidationPluginTranslator.class, typeId));
        }
    }
}

