/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.ContentCopy;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.LinkedData;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.LinkedDataFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDms;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.externaldms.ExternalDmsAddressType;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.ILinkedDataContentCopiesTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.ILinkedDataTranslator;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkedDataTranslator
extends AbstractCachingTranslator<Long, LinkedData, LinkedDataFetchOptions>
implements ILinkedDataTranslator {
    @Autowired
    private ILinkedDataContentCopiesTranslator contentCopiesTranslator;

    @Override
    protected LinkedData createObject(TranslationContext context, Long dataSetId, LinkedDataFetchOptions fetchOptions) {
        LinkedData linkedData = new LinkedData();
        linkedData.setFetchOptions(new LinkedDataFetchOptions());
        return linkedData;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> dataSetIds, LinkedDataFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ILinkedDataContentCopiesTranslator.class, this.contentCopiesTranslator.translate(context, dataSetIds, fetchOptions));
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long dataSetId, LinkedData result, Object objectRelations, LinkedDataFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        Collection copies = (Collection)relations.get(ILinkedDataContentCopiesTranslator.class, dataSetId);
        ArrayList copyList = new ArrayList(copies);
        result.setContentCopies(copyList);
        String externalCode = "";
        if (fetchOptions.hasExternalDms()) {
            ExternalDms externalDms = null;
            for (ContentCopy copy : copyList) {
                ExternalDmsAddressType type = copy.getExternalDms().getAddressType();
                if (!type.equals((Object)ExternalDmsAddressType.OPENBIS) && !type.equals((Object)ExternalDmsAddressType.URL)) continue;
                externalCode = copy.getExternalCode();
                externalDms = copy.getExternalDms();
                break;
            }
            if (externalDms != null) {
                result.setExternalDms(externalDms);
                result.getFetchOptions().withExternalDmsUsing(fetchOptions.withExternalDms());
            }
        }
        result.setExternalCode(externalCode);
    }
}

