/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.StorageFormat;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.StorageFormatFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.VocabularyTerm;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyTermFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectToOneRelationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.DataSetQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IPhysicalDataStorageFormatTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTermTranslator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhysicalDataStorageFormatTranslator
extends ObjectToOneRelationTranslator<StorageFormat, StorageFormatFetchOptions>
implements IPhysicalDataStorageFormatTranslator {
    @Autowired
    private IVocabularyTermTranslator vocabularyTermTranslator;

    @Override
    protected List<ObjectRelationRecord> loadRecords(LongOpenHashSet objectIds) {
        DataSetQuery query = (DataSetQuery)QueryTool.getManagedQuery(DataSetQuery.class);
        return query.getStorageFormatIds((LongSet)objectIds);
    }

    @Override
    protected Map<Long, StorageFormat> translateRelated(TranslationContext context, Collection<Long> relatedIds, StorageFormatFetchOptions relatedFetchOptions) {
        Map termMap = this.vocabularyTermTranslator.translate(context, relatedIds, new VocabularyTermFetchOptions());
        HashMap<Long, StorageFormat> formatMap = new HashMap<Long, StorageFormat>();
        for (Map.Entry termEntry : termMap.entrySet()) {
            Long id = termEntry.getKey();
            VocabularyTerm term = (VocabularyTerm)termEntry.getValue();
            StorageFormat format = null;
            if (term != null) {
                format = new StorageFormat();
                format.setCode(term.getCode());
                format.setDescription(term.getDescription());
            }
            formatMap.put(id, format);
        }
        return formatMap;
    }
}

