/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.datastore;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.DataStore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.fetchoptions.DataStoreFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.datastore.DataStoreBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.datastore.IDataStoreBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.datastore.IDataStoreTranslator;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataStoreTranslator
extends AbstractCachingTranslator<Long, DataStore, DataStoreFetchOptions>
implements IDataStoreTranslator {
    @Autowired
    private IDataStoreBaseTranslator baseTranslator;

    @Override
    protected DataStore createObject(TranslationContext context, Long dataStoreId, DataStoreFetchOptions fetchOptions) {
        DataStore dataStore = new DataStore();
        dataStore.setFetchOptions(new DataStoreFetchOptions());
        return dataStore;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> dataStoreIds, DataStoreFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IDataStoreBaseTranslator.class, this.baseTranslator.translate(context, dataStoreIds, null));
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long dataStoreId, DataStore result, Object objectRelations, DataStoreFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        DataStoreBaseRecord baseRecord = (DataStoreBaseRecord)relations.get(IDataStoreBaseTranslator.class, dataStoreId);
        result.setCode(baseRecord.code);
        result.setDownloadUrl(baseRecord.downloadUrl);
        result.setRemoteUrl(baseRecord.remoteUrl);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setModificationDate(baseRecord.modificationDate);
    }
}

