/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.event;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.EntityType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.Event;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.EventType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.fetchoptions.EventFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.id.EventTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.event.id.IEventId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpaceTechId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.event.IEventAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.event.EventBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.event.IEventBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.event.IEventRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.event.IEventTranslator;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventTranslator
extends AbstractCachingTranslator<Long, Event, EventFetchOptions>
implements IEventTranslator {
    @Autowired
    private IEventAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IEventBaseTranslator baseTranslator;
    @Autowired
    private IEventRegistratorTranslator registratorTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> inputs, EventFetchOptions fetchOptions) {
        this.authorizationExecutor.canGet(new OperationContext(context.getSession()));
        return new HashSet<Long>(inputs);
    }

    @Override
    protected Event createObject(TranslationContext context, Long input, EventFetchOptions fetchOptions) {
        Event event = new Event();
        event.setFetchOptions(new EventFetchOptions());
        return event;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> inputs, EventFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IEventBaseTranslator.class, this.baseTranslator.translate(context, inputs, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IEventRegistratorTranslator.class, this.registratorTranslator.translate(context, inputs, fetchOptions.withRegistrator()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long input, Event output, Object objectRelations, EventFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        EventBaseRecord baseRecord = (EventBaseRecord)relations.get(IEventBaseTranslator.class, input);
        output.setId((IEventId)new EventTechId(baseRecord.id));
        output.setEventType(this.translateEventType(baseRecord.eventType));
        output.setEntityType(this.translateEntityType(baseRecord.entityType));
        output.setEntitySpace(baseRecord.entitySpace);
        output.setEntitySpaceId((ISpaceId)(baseRecord.entitySpaceId != null ? new SpaceTechId(Long.valueOf(baseRecord.entitySpaceId)) : null));
        output.setEntityProject(baseRecord.entityProject);
        output.setEntityProjectId((IProjectId)(baseRecord.entityProjectId != null ? new ProjectPermId(baseRecord.entityProjectId) : null));
        output.setEntityRegistrator(baseRecord.entityRegistrator);
        output.setEntityRegistrationDate(baseRecord.entityRegistrationDate);
        output.setIdentifier(baseRecord.identifier);
        output.setDescription(baseRecord.description);
        output.setReason(baseRecord.reason);
        output.setContent(baseRecord.content);
        output.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasRegistrator()) {
            output.setRegistrator((Person)relations.get(IEventRegistratorTranslator.class, input));
            output.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
    }

    private EventType translateEventType(String eventType) {
        return EventType.valueOf((String)eventType);
    }

    private EntityType translateEntityType(String entityType) {
        if (EventPE.EntityType.DATASET.name().equals(entityType)) {
            return EntityType.DATA_SET;
        }
        if (EventPE.EntityType.METAPROJECT.name().equals(entityType)) {
            return EntityType.TAG;
        }
        return EntityType.valueOf((String)entityType);
    }
}

