/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.history.ExperimentRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.IRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.id.UnknownRelatedObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExperimentHistoryTranslator
extends HistoryTranslator
implements IExperimentHistoryTranslator {
    @Autowired
    private IProjectAuthorizationValidator projectValidator;
    @Autowired
    private ISampleAuthorizationValidator sampleValidator;
    @Autowired
    private IDataSetAuthorizationValidator dataSetValidator;

    @Override
    protected List<? extends PropertyRecord> loadProperties(Collection<Long> entityIds) {
        ExperimentQuery query = (ExperimentQuery)QueryTool.getManagedQuery(ExperimentQuery.class);
        return query.getProperties((LongSet)new LongOpenHashSet(entityIds));
    }

    protected List<HistoryPropertyRecord> loadPropertyHistory(Collection<Long> entityIds) {
        ExperimentQuery query = (ExperimentQuery)QueryTool.getManagedQuery(ExperimentQuery.class);
        return query.getPropertiesHistory((LongSet)new LongOpenHashSet(entityIds));
    }

    @Override
    protected List<? extends HistoryRelationshipRecord> loadRelationshipHistory(TranslationContext context, Collection<Long> entityIds) {
        ExperimentQuery query = (ExperimentQuery)QueryTool.getManagedQuery(ExperimentQuery.class);
        List<ExperimentRelationshipRecord> records = query.getRelationshipsHistory((LongSet)new LongOpenHashSet(entityIds));
        ArrayList<ExperimentRelationshipRecord> validRecords = new ArrayList<ExperimentRelationshipRecord>();
        Set<Long> projectIds = new HashSet<Long>();
        Set<Long> sampleIds = new HashSet<Long>();
        Set<Long> dataSetIds = new HashSet<Long>();
        for (ExperimentRelationshipRecord record : records) {
            if (record.projectId != null) {
                projectIds.add(record.projectId);
                continue;
            }
            if (record.sampleId != null) {
                sampleIds.add(record.sampleId);
                continue;
            }
            if (record.dataSetId == null) continue;
            dataSetIds.add(record.dataSetId);
        }
        if (!projectIds.isEmpty()) {
            projectIds = this.projectValidator.validate(context.getSession().tryGetPerson(), projectIds);
        }
        if (!sampleIds.isEmpty()) {
            sampleIds = this.sampleValidator.validate(context.getSession().tryGetPerson(), sampleIds);
        }
        if (!dataSetIds.isEmpty()) {
            dataSetIds = this.dataSetValidator.validate(context.getSession().tryGetPerson(), dataSetIds);
        }
        boolean isSystemUser = context.getSession().tryGetPerson() != null && context.getSession().tryGetPerson().isSystemUser();
        for (ExperimentRelationshipRecord record : records) {
            boolean isValid = false;
            isValid = record.projectId != null ? projectIds.contains(record.projectId) : (record.sampleId != null ? sampleIds.contains(record.sampleId) : (record.dataSetId != null ? dataSetIds.contains(record.dataSetId) : isSystemUser));
            if (!isValid) continue;
            validRecords.add(record);
        }
        return validRecords;
    }

    @Override
    protected RelationHistoryEntry createRelationshipEntry(HistoryRelationshipRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        RelationHistoryEntry entry = super.createRelationshipEntry(record, authorMap, fetchOptions);
        ExperimentRelationshipRecord experimentRecord = (ExperimentRelationshipRecord)record;
        if (this.isProject(experimentRecord)) {
            entry.setRelationType((IRelationType)ExperimentRelationType.PROJECT);
            entry.setRelatedObjectId((IObjectId)new ProjectPermId(experimentRecord.relatedObjectId));
        } else if (this.isSample(experimentRecord)) {
            entry.setRelationType((IRelationType)ExperimentRelationType.SAMPLE);
            entry.setRelatedObjectId((IObjectId)new SamplePermId(experimentRecord.relatedObjectId));
        } else if (this.isDataSet(experimentRecord)) {
            entry.setRelationType((IRelationType)ExperimentRelationType.DATA_SET);
            entry.setRelatedObjectId((IObjectId)new DataSetPermId(experimentRecord.relatedObjectId));
        } else {
            entry.setRelatedObjectId((IObjectId)new UnknownRelatedObjectId(experimentRecord.relatedObjectId, experimentRecord.relationType));
        }
        return entry;
    }
}

