/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment;

import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentTypeBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.MaterialPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyAssignmentRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.SamplePropertyRecord;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.lemnik.eodsql.Select;

public interface ExperimentQuery
extends ObjectQuery {
    @Select(sql="select e.id, e.code, e.perm_id as permId, p.code as projectCode, sp.code as spaceCode, e.registration_timestamp as registrationDate, e.modification_timestamp as modificationDate, e.frozen as frozen, e.frozen_for_data as frozenForDataSets, e.frozen_for_samp as frozenForSamples from experiments e join projects p on e.proj_id = p.id join spaces sp on p.space_id = sp.id where e.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ExperimentBaseRecord> getExperiments(LongSet var1);

    @Select(sql="select e.id as objectId, e.exty_id as relatedId from experiments e where e.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getTypeIds(LongSet var1);

    @Select(sql="select et.id, et.code, et.description, et.modification_timestamp as modificationDate from experiment_types et where et.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ExperimentTypeBaseRecord> getTypes(LongSet var1);

    @Select(sql="select e.id as objectId, e.proj_id as relatedId from experiments e where e.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getProjectIds(LongSet var1);

    @Select(sql="select s.expe_id as objectId, s.id as relatedId from samples s where s.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getSampleIds(LongSet var1);

    @Select(sql="select d.expe_id as objectId, d.id as relatedId from data d where d.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getDataSetIds(LongSet var1);

    @Select(sql="select p.id as id, p.expe_id as objectId, p.pers_id_author AS authorId, p.modification_timestamp AS modificationTimestamp, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.value as propertyValue, m.code as materialPropertyValueCode, mt.code as materialPropertyValueTypeCode, s.perm_id as sample_perm_id, s.id as sample_id, cvt.code as vocabularyPropertyValue, cv.code as vocabularyPropertyValueTypeCode from experiment_properties p left join samples s on p.samp_prop_id = s.id left join materials m on p.mate_prop_id = m.id left join controlled_vocabulary_terms cvt on p.cvte_id = cvt.id left join controlled_vocabularies cv on cvt.covo_id = cv.id left join material_types mt on m.maty_id = mt.id join experiment_type_property_types etpt on p.etpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<PropertyRecord> getProperties(LongSet var1);

    @Select(sql="select p.expe_id as objectId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.mate_prop_id as propertyValue from experiment_properties p join experiment_type_property_types etpt on p.etpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.mate_prop_id is not null and p.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MaterialPropertyRecord> getMaterialProperties(LongSet var1);

    @Select(sql="select p.expe_id as objectId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.samp_prop_id as propertyValue from experiment_properties p join experiment_type_property_types etpt on p.etpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.samp_prop_id is not null and p.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<SamplePropertyRecord> getSampleProperties(LongSet var1);

    @Select(sql="select ph.id as id, ph.expe_id as objectId, ph.pers_id_author as authorId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, ph.value as propertyValue, ph.material as materialPropertyValue, ph.sample as samplePropertyValue, ph.vocabulary_term as vocabularyPropertyValue, ph.valid_from_timestamp as validFrom, ph.valid_until_timestamp as validTo from experiment_properties_history ph join experiment_type_property_types etpt on ph.etpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where ph.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<HistoryPropertyRecord> getPropertiesHistory(LongSet var1);

    @Select(sql="select erh.id as id, erh.main_expe_id as objectId, erh.pers_id_author as authorId, erh.relation_type as relationType, erh.entity_kind as entityKind, erh.entity_perm_id as relatedObjectId, erh.valid_from_timestamp as validFrom, erh.valid_until_timestamp as validTo, erh.proj_id as projectId, erh.samp_id as sampleId, erh.data_id as dataSetId from experiment_relationships_history erh where erh.main_expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ExperimentRelationshipRecord> getRelationshipsHistory(LongSet var1);

    @Select(sql="select e.id as objectId, e.pers_id_registerer as relatedId from experiments e where e.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getRegistratorIds(LongSet var1);

    @Select(sql="select e.id as objectId, e.pers_id_modifier as relatedId from experiments e where e.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getModifierIds(LongSet var1);

    @Select(sql="select ma.expe_id as objectId, ma.mepr_id as relatedId from metaproject_assignments ma where ma.expe_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getTagIds(LongSet var1);

    @Select(sql="select exty_id as objectId, id as relatedId from experiment_type_property_types where exty_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getPropertyAssignmentIds(LongSet var1);

    @Select(sql="select t.id as objectId, t.validation_script_id as relatedId from experiment_types t where t.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getValidationPluginIds(LongSet var1);

    @Select(sql="select pt.code as prty_code, pt.is_managed_internally as prty_is_managed_internally, 'EXPERIMENT' as kind_code, et.id as type_id, et.code as type_code, etpt.* from experiment_type_property_types etpt, property_types pt, experiment_types et where etpt.id = any(?{1}) and etpt.prty_id = pt.id and etpt.exty_id = et.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<PropertyAssignmentRecord> getPropertyAssignments(LongSet var1);
}

