/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAttachmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentDataSetTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentModifierTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentProjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentSamplePropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentSampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTagTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTypeRelationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleSamplePropertyTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExperimentTranslator
extends AbstractCachingTranslator<Long, Experiment, ExperimentFetchOptions>
implements IExperimentTranslator {
    @Autowired
    private IExperimentAuthorizationValidator authorizationValidator;
    @Autowired
    private IExperimentBaseTranslator baseTranslator;
    @Autowired
    private IExperimentTypeRelationTranslator typeTranslator;
    @Autowired
    private IExperimentProjectTranslator projectTranslator;
    @Autowired
    private IExperimentSampleTranslator sampleTranslator;
    @Autowired
    private IExperimentDataSetTranslator dataSetTranslator;
    @Autowired
    private IExperimentPropertyTranslator propertyTranslator;
    @Autowired
    private IExperimentMaterialPropertyTranslator materialPropertyTranslator;
    @Autowired
    private IExperimentSamplePropertyTranslator samplePropertyTranslator;
    @Autowired
    private IExperimentRegistratorTranslator registratorTranslator;
    @Autowired
    private IExperimentModifierTranslator modifierTranslator;
    @Autowired
    private IExperimentTagTranslator tagTranslator;
    @Autowired
    private IExperimentAttachmentTranslator attachmentTranslator;
    @Autowired
    private IExperimentHistoryTranslator historyTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> experimentIds, ExperimentFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), experimentIds);
    }

    @Override
    protected Experiment createObject(TranslationContext context, Long experimentId, ExperimentFetchOptions fetchOptions) {
        Experiment experiment = new Experiment();
        experiment.setFetchOptions(new ExperimentFetchOptions());
        return experiment;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> experimentIds, ExperimentFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IExperimentBaseTranslator.class, this.baseTranslator.translate(context, experimentIds, null));
        if (fetchOptions.hasType()) {
            relations.put(IExperimentTypeRelationTranslator.class, this.typeTranslator.translate(context, experimentIds, fetchOptions.withType()));
        }
        if (fetchOptions.hasProject()) {
            relations.put(IExperimentProjectTranslator.class, this.projectTranslator.translate(context, experimentIds, fetchOptions.withProject()));
        }
        if (fetchOptions.hasSamples()) {
            relations.put(IExperimentSampleTranslator.class, this.sampleTranslator.translate(context, experimentIds, fetchOptions.withSamples()));
        }
        if (fetchOptions.hasDataSets()) {
            relations.put(IExperimentDataSetTranslator.class, this.dataSetTranslator.translate(context, experimentIds, fetchOptions.withDataSets()));
        }
        if (fetchOptions.hasProperties()) {
            relations.put(IExperimentPropertyTranslator.class, this.propertyTranslator.translate(context, experimentIds, fetchOptions.withProperties()));
        }
        if (fetchOptions.hasMaterialProperties()) {
            relations.put(IExperimentMaterialPropertyTranslator.class, this.materialPropertyTranslator.translate(context, experimentIds, fetchOptions.withMaterialProperties()));
        }
        if (fetchOptions.hasSampleProperties()) {
            relations.put(ISampleSamplePropertyTranslator.class, this.samplePropertyTranslator.translate(context, experimentIds, fetchOptions.withSampleProperties()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IExperimentRegistratorTranslator.class, this.registratorTranslator.translate(context, experimentIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasModifier()) {
            relations.put(IExperimentModifierTranslator.class, this.modifierTranslator.translate(context, experimentIds, fetchOptions.withModifier()));
        }
        if (fetchOptions.hasTags()) {
            relations.put(IExperimentTagTranslator.class, this.tagTranslator.translate(context, experimentIds, fetchOptions.withTags()));
        }
        if (fetchOptions.hasAttachments()) {
            relations.put(IExperimentAttachmentTranslator.class, this.attachmentTranslator.translate(context, experimentIds, fetchOptions.withAttachments()));
        }
        if (fetchOptions.hasHistory()) {
            relations.put(IExperimentHistoryTranslator.class, this.historyTranslator.translate(context, experimentIds, fetchOptions.withHistory()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long experimentId, Experiment result, Object objectRelations, ExperimentFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        ExperimentBaseRecord baseRecord = (ExperimentBaseRecord)relations.get(IExperimentBaseTranslator.class, experimentId);
        result.setCode(baseRecord.code);
        result.setPermId(new ExperimentPermId(baseRecord.permId));
        result.setIdentifier(new ExperimentIdentifier(baseRecord.spaceCode, baseRecord.projectCode, baseRecord.code));
        result.setFrozen(baseRecord.frozen);
        result.setFrozenForDataSets(baseRecord.frozenForDataSets);
        result.setFrozenForSamples(baseRecord.frozenForSamples);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasType()) {
            result.setType((ExperimentType)relations.get(IExperimentTypeRelationTranslator.class, experimentId));
            result.getFetchOptions().withTypeUsing(fetchOptions.withType());
        }
        if (fetchOptions.hasProject()) {
            result.setProject((Project)relations.get(IExperimentProjectTranslator.class, experimentId));
            result.getFetchOptions().withProjectUsing(fetchOptions.withProject());
        }
        if (fetchOptions.hasSamples()) {
            result.setSamples(SampleUtils.extractSamples((Collection)relations.get(IExperimentSampleTranslator.class, experimentId)));
            result.getFetchOptions().withSamplesUsing(fetchOptions.withSamples());
        }
        if (fetchOptions.hasDataSets()) {
            result.setDataSets((List)relations.get(IExperimentDataSetTranslator.class, experimentId));
            result.getFetchOptions().withDataSetsUsing(fetchOptions.withDataSets());
        }
        if (fetchOptions.hasProperties()) {
            result.setProperties((Map)relations.get(IExperimentPropertyTranslator.class, experimentId));
            result.getFetchOptions().withPropertiesUsing(fetchOptions.withProperties());
        }
        if (fetchOptions.hasMaterialProperties()) {
            result.setMaterialProperties((Map)relations.get(IExperimentMaterialPropertyTranslator.class, experimentId));
            result.getFetchOptions().withMaterialPropertiesUsing(fetchOptions.withMaterialProperties());
        }
        if (fetchOptions.hasSampleProperties()) {
            result.setSampleProperties((Map)relations.get(ISampleSamplePropertyTranslator.class, experimentId));
            result.getFetchOptions().withSamplePropertiesUsing(fetchOptions.withSampleProperties());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IExperimentRegistratorTranslator.class, experimentId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasModifier()) {
            result.setModifier((Person)relations.get(IExperimentModifierTranslator.class, experimentId));
            result.getFetchOptions().withModifierUsing(fetchOptions.withModifier());
        }
        if (fetchOptions.hasTags()) {
            result.setTags((Set)relations.get(IExperimentTagTranslator.class, experimentId));
            result.getFetchOptions().withTagsUsing(fetchOptions.withTags());
        }
        if (fetchOptions.hasAttachments()) {
            result.setAttachments((List)relations.get(IExperimentAttachmentTranslator.class, experimentId));
            result.getFetchOptions().withAttachmentsUsing(fetchOptions.withAttachments());
        }
        if (fetchOptions.hasHistory()) {
            result.setHistory((List)relations.get(IExperimentHistoryTranslator.class, experimentId));
            result.getFetchOptions().withHistoryUsing(fetchOptions.withHistory());
        }
    }
}

