/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.ExperimentType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.ExperimentTypeBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentPropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTypeBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTypeValidationPluginTranslator;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExperimentTypeTranslator
extends AbstractCachingTranslator<Long, ExperimentType, ExperimentTypeFetchOptions>
implements IExperimentTypeTranslator {
    @Autowired
    private IExperimentTypeBaseTranslator baseTranslator;
    @Autowired
    private IExperimentPropertyAssignmentTranslator assignmentTranslator;
    @Autowired
    private IExperimentTypeValidationPluginTranslator validationPluginTranslator;

    @Override
    protected ExperimentType createObject(TranslationContext context, Long typeId, ExperimentTypeFetchOptions fetchOptions) {
        ExperimentType type = new ExperimentType();
        type.setFetchOptions(fetchOptions);
        return type;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> typeIds, ExperimentTypeFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IExperimentTypeBaseTranslator.class, this.baseTranslator.translate(context, typeIds, null));
        if (fetchOptions.hasPropertyAssignments()) {
            relations.put(IExperimentPropertyAssignmentTranslator.class, this.assignmentTranslator.translate(context, typeIds, fetchOptions.withPropertyAssignments()));
        }
        if (fetchOptions.hasValidationPlugin()) {
            relations.put(IExperimentTypeValidationPluginTranslator.class, this.validationPluginTranslator.translate(context, typeIds, fetchOptions.withValidationPlugin()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long typeId, ExperimentType result, Object objectRelations, ExperimentTypeFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        ExperimentTypeBaseRecord baseRecord = (ExperimentTypeBaseRecord)relations.get(IExperimentTypeBaseTranslator.class, typeId);
        result.setPermId(new EntityTypePermId(baseRecord.code, EntityKind.EXPERIMENT));
        result.setCode(baseRecord.code);
        result.setDescription(baseRecord.description);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasPropertyAssignments()) {
            result.setPropertyAssignments((List)relations.get(IExperimentPropertyAssignmentTranslator.class, typeId));
        }
        if (fetchOptions.hasValidationPlugin()) {
            result.setValidationPlugin((Plugin)relations.get(IExperimentTypeValidationPluginTranslator.class, typeId));
        }
    }
}

