/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.globalsearch;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.GlobalSearchObject;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.fetchoptions.GlobalSearchObjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.global.search.GlobalSearchObjectKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationCache;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.globalsearch.IGlobalSearchObjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTranslator;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.MatchingEntityValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalSearchObjectTranslator
extends AbstractCachingTranslator<MatchingEntity, GlobalSearchObject, GlobalSearchObjectFetchOptions>
implements IGlobalSearchObjectTranslator {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IExperimentTranslator experimentTranslator;
    @Autowired
    private ISampleTranslator sampleTranslator;
    @Autowired
    private IDataSetTranslator dataSetTranslator;
    @Autowired
    private IMaterialTranslator materialTranslator;

    @Override
    protected Set<MatchingEntity> shouldTranslate(TranslationContext context, Collection<MatchingEntity> inputs, GlobalSearchObjectFetchOptions fetchOptions) {
        MatchingEntityValidator validator = new MatchingEntityValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        return new HashSet<MatchingEntity>(validator.getValid(context.getSession().tryGetPerson(), inputs));
    }

    @Override
    protected TranslationCache.CacheKey getObjectCacheKey(MatchingEntity input, GlobalSearchObjectFetchOptions fetchOptions) {
        return new TranslationCache.CacheKey(this.getClass().getName() + "." + input.getEntityKind(), this.getObjectId(input), (FetchOptions<?>)fetchOptions);
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<MatchingEntity> inputs, GlobalSearchObjectFetchOptions fetchOptions) {
        if (!(fetchOptions.hasExperiment() || fetchOptions.hasSample() || fetchOptions.hasDataSet() || fetchOptions.hasMaterial())) {
            return Collections.emptyMap();
        }
        LinkedList<Long> experimentIds = new LinkedList<Long>();
        LinkedList<Long> sampleIds = new LinkedList<Long>();
        LinkedList<Long> dataSetIds = new LinkedList<Long>();
        LinkedList<Long> materialIds = new LinkedList<Long>();
        block6: for (MatchingEntity input : inputs) {
            switch (input.getEntityKind()) {
                case EXPERIMENT: {
                    experimentIds.add(input.getId());
                    continue block6;
                }
                case SAMPLE: {
                    sampleIds.add(input.getId());
                    continue block6;
                }
                case DATA_SET: {
                    dataSetIds.add(input.getId());
                    continue block6;
                }
                case MATERIAL: {
                    materialIds.add(input.getId());
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported entity kind " + input.getEntityKind());
        }
        HashMap relations = new HashMap();
        if (fetchOptions.hasExperiment()) {
            relations.put(IExperimentTranslator.class, this.experimentTranslator.translate(context, experimentIds, fetchOptions.withExperiment()));
        }
        if (fetchOptions.hasSample()) {
            relations.put(ISampleTranslator.class, this.sampleTranslator.translate(context, sampleIds, fetchOptions.withSample()));
        }
        if (fetchOptions.hasDataSet()) {
            relations.put(IDataSetTranslator.class, this.dataSetTranslator.translate(context, dataSetIds, fetchOptions.withDataSet()));
        }
        if (fetchOptions.hasMaterial()) {
            relations.put(IMaterialTranslator.class, this.materialTranslator.translate(context, materialIds, fetchOptions.withMaterial()));
        }
        return relations;
    }

    @Override
    protected GlobalSearchObject createObject(TranslationContext context, MatchingEntity input, GlobalSearchObjectFetchOptions fetchOptions) {
        GlobalSearchObject object = new GlobalSearchObject();
        object.setObjectKind(this.getObjectKind(input));
        object.setObjectPermId(this.getObjectPermId(input));
        object.setObjectIdentifier(this.getObjectIdentifier(input));
        if (input.getMatches() != null) {
            String s = "";
            for (PropertyMatch p : input.getMatches()) {
                s = s + p.getCode() + ": " + p.getValue() + "\n";
            }
            object.setMatch(s.trim());
        }
        object.setScore(input.getScore());
        object.setFetchOptions(new GlobalSearchObjectFetchOptions());
        return object;
    }

    @Override
    protected void updateObject(TranslationContext context, MatchingEntity input, GlobalSearchObject output, Object objectRelations, GlobalSearchObjectFetchOptions fetchOptions) {
        Map relations = (Map)objectRelations;
        if (fetchOptions.hasExperiment()) {
            Map experiments;
            output.getFetchOptions().withExperimentUsing(fetchOptions.withExperiment());
            if (EntityKind.EXPERIMENT.equals((Object)input.getEntityKind()) && (experiments = (Map)relations.get(IExperimentTranslator.class)) != null) {
                output.setExperiment((Experiment)experiments.get(input.getId()));
            }
        }
        if (fetchOptions.hasSample()) {
            Map samples;
            output.getFetchOptions().withSampleUsing(fetchOptions.withSample());
            if (EntityKind.SAMPLE.equals((Object)input.getEntityKind()) && (samples = (Map)relations.get(ISampleTranslator.class)) != null) {
                output.setSample((Sample)samples.get(input.getId()));
            }
        }
        if (fetchOptions.hasDataSet()) {
            Map dataSets;
            output.getFetchOptions().withDataSetUsing(fetchOptions.withDataSet());
            if (EntityKind.DATA_SET.equals((Object)input.getEntityKind()) && (dataSets = (Map)relations.get(IDataSetTranslator.class)) != null) {
                output.setDataSet((DataSet)dataSets.get(input.getId()));
            }
        }
        if (fetchOptions.hasMaterial()) {
            Map materials;
            output.getFetchOptions().withMaterialUsing(fetchOptions.withMaterial());
            if (EntityKind.MATERIAL.equals((Object)input.getEntityKind()) && (materials = (Map)relations.get(IMaterialTranslator.class)) != null) {
                output.setMaterial((Material)materials.get(input.getId()));
            }
        }
    }

    private IObjectId getObjectPermId(MatchingEntity input) {
        switch (input.getEntityKind()) {
            case EXPERIMENT: {
                return new ExperimentPermId(input.getPermId());
            }
            case SAMPLE: {
                return new SamplePermId(input.getPermId());
            }
            case DATA_SET: {
                return new DataSetPermId(input.getCode());
            }
            case MATERIAL: {
                return new MaterialPermId(input.getCode(), input.getEntityType().getCode());
            }
        }
        throw new UnsupportedOperationException("Unsupported entity kind " + input.getEntityKind());
    }

    private IObjectId getObjectIdentifier(MatchingEntity input) {
        switch (input.getEntityKind()) {
            case EXPERIMENT: {
                return new ExperimentIdentifier(input.getIdentifier());
            }
            case SAMPLE: {
                return new SampleIdentifier(input.getIdentifier());
            }
            case DATA_SET: {
                return new DataSetPermId(input.getCode());
            }
            case MATERIAL: {
                return new MaterialPermId(input.getCode(), input.getEntityType().getCode());
            }
        }
        throw new UnsupportedOperationException("Unsupported entity kind " + input.getEntityKind());
    }

    private GlobalSearchObjectKind getObjectKind(MatchingEntity input) {
        switch (input.getEntityKind()) {
            case EXPERIMENT: {
                return GlobalSearchObjectKind.EXPERIMENT;
            }
            case SAMPLE: {
                return GlobalSearchObjectKind.SAMPLE;
            }
            case DATA_SET: {
                return GlobalSearchObjectKind.DATA_SET;
            }
            case MATERIAL: {
                return GlobalSearchObjectKind.MATERIAL;
            }
        }
        throw new UnsupportedOperationException("Unsupported entity kind " + input.getEntityKind());
    }
}

