/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.HistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.PropertyHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.IHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class HistoryTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<List<HistoryEntry>>, HistoryEntryFetchOptions>
implements IHistoryTranslator {
    @Autowired
    private IPersonTranslator personTranslator;

    protected abstract List<? extends PropertyRecord> loadProperties(Collection<Long> var1);

    protected abstract List<? extends HistoryPropertyRecord> loadPropertyHistory(Collection<Long> var1);

    protected abstract List<? extends HistoryRelationshipRecord> loadRelationshipHistory(TranslationContext var1, Collection<Long> var2);

    protected List<? extends HistoryRecord> loadAbritraryHistory(TranslationContext context, Collection<Long> entityIds) {
        return null;
    }

    @Override
    protected ObjectHolder<List<HistoryEntry>> createObject(TranslationContext context, Long entityId, HistoryEntryFetchOptions fetchOptions) {
        return new ObjectHolder<List<HistoryEntry>>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> entityIds, HistoryEntryFetchOptions fetchOptions) {
        List<? extends HistoryPropertyRecord> oldProperties = this.loadPropertyHistory(entityIds);
        List<? extends PropertyRecord> currentProperties = this.loadProperties(entityIds);
        ArrayList<? extends HistoryPropertyRecord> properties = new ArrayList<HistoryPropertyRecord>();
        if (oldProperties != null) {
            properties.addAll(oldProperties);
        }
        if (currentProperties != null) {
            for (PropertyRecord propertyRecord : currentProperties) {
                HistoryPropertyRecord currentPropertyRecord = new HistoryPropertyRecord();
                currentPropertyRecord.id = propertyRecord.id;
                currentPropertyRecord.authorId = propertyRecord.authorId;
                currentPropertyRecord.validFrom = propertyRecord.modificationTimestamp;
                currentPropertyRecord.validTo = null;
                currentPropertyRecord.objectId = propertyRecord.objectId;
                currentPropertyRecord.propertyCode = propertyRecord.propertyCode;
                currentPropertyRecord.propertyValue = propertyRecord.propertyValue;
                currentPropertyRecord.samplePropertyValue = propertyRecord.sample_perm_id;
                if (propertyRecord.vocabularyPropertyValue != null && propertyRecord.vocabularyPropertyValueTypeCode != null) {
                    currentPropertyRecord.vocabularyPropertyValue = propertyRecord.vocabularyPropertyValue + " [" + propertyRecord.vocabularyPropertyValueTypeCode + "]";
                }
                if (propertyRecord.materialPropertyValueCode != null && propertyRecord.materialPropertyValueTypeCode != null) {
                    currentPropertyRecord.materialPropertyValue = propertyRecord.materialPropertyValueCode + " [" + propertyRecord.materialPropertyValueTypeCode + "]";
                }
                properties.add(currentPropertyRecord);
            }
        }
        List<? extends HistoryRelationshipRecord> relationships = this.loadRelationshipHistory(context, entityIds);
        List<? extends HistoryRecord> list = this.loadAbritraryHistory(context, entityIds);
        Map<Long, Object> authorMap = new HashMap<Long, Person>();
        if (fetchOptions.hasAuthor()) {
            HashSet<Long> authorIds = new HashSet<Long>();
            ArrayList<? extends HistoryRecord> completeHistory = new ArrayList<HistoryRecord>();
            if (properties != null) {
                completeHistory.addAll(properties);
            }
            if (relationships != null) {
                completeHistory.addAll(relationships);
            }
            if (list != null) {
                completeHistory.addAll(list);
            }
            for (HistoryRecord historyRecord : completeHistory) {
                if (historyRecord.authorId == null) continue;
                authorIds.add(historyRecord.authorId);
            }
            authorMap = this.personTranslator.translate(context, authorIds, fetchOptions.withAuthor());
        }
        HashMap<Long, List<HistoryEntry>> entriesMap = new HashMap<Long, List<HistoryEntry>>();
        if (properties != null) {
            this.createPropertyEntries(entriesMap, properties, authorMap, fetchOptions);
        }
        if (relationships != null) {
            this.createRelationshipEntries(entriesMap, relationships, authorMap, fetchOptions);
        }
        if (list != null) {
            this.createArbitraryEntries(entriesMap, list, authorMap, fetchOptions);
        }
        for (Long entityId : entityIds) {
            if (entriesMap.containsKey(entityId)) continue;
            entriesMap.put(entityId, Collections.emptyList());
        }
        return entriesMap;
    }

    @Override
    protected void updateObject(TranslationContext context, Long entityId, ObjectHolder<List<HistoryEntry>> result, Object relations, HistoryEntryFetchOptions fetchOptions) {
        Map entriesMap = (Map)relations;
        result.setObject((List)entriesMap.get(entityId));
    }

    private void createPropertyEntries(Map<Long, List<HistoryEntry>> entriesMap, List<? extends HistoryPropertyRecord> records, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        ArrayList<? extends HistoryPropertyRecord> sortedRecords = new ArrayList<HistoryPropertyRecord>(records);
        sortedRecords.sort(Comparator.comparing(HistoryRecord::getValidFrom).thenComparing(HistoryRecord::getValidTo, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(HistoryPropertyRecord::getPropertyCode).thenComparing(ObjectBaseRecord::getId));
        for (HistoryPropertyRecord historyPropertyRecord : sortedRecords) {
            List<HistoryEntry> entries = entriesMap.get(historyPropertyRecord.objectId);
            if (entries == null) {
                entries = new LinkedList<HistoryEntry>();
                entriesMap.put(historyPropertyRecord.objectId, entries);
            }
            entries.add((HistoryEntry)this.createPropertyEntry(historyPropertyRecord, authorMap, fetchOptions));
        }
    }

    protected PropertyHistoryEntry createPropertyEntry(HistoryPropertyRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        PropertyHistoryEntry entry = new PropertyHistoryEntry();
        entry.setFetchOptions(new HistoryEntryFetchOptions());
        entry.setValidFrom(record.validFrom);
        entry.setValidTo(record.validTo);
        entry.setPropertyName(record.propertyCode);
        if (record.propertyValue != null) {
            entry.setPropertyValue(record.propertyValue);
        } else if (record.vocabularyPropertyValue != null) {
            entry.setPropertyValue(record.vocabularyPropertyValue);
        } else if (record.materialPropertyValue != null) {
            entry.setPropertyValue(record.materialPropertyValue);
        } else if (record.samplePropertyValue != null) {
            entry.setPropertyValue(record.samplePropertyValue);
        } else {
            throw new IllegalArgumentException("Unexpected property history entry with all values null");
        }
        if (fetchOptions.hasAuthor()) {
            entry.setAuthor(authorMap.get(record.authorId));
            entry.getFetchOptions().withAuthorUsing(fetchOptions.withAuthor());
        }
        return entry;
    }

    protected void createArbitraryEntries(Map<Long, List<HistoryEntry>> entriesMap, List<? extends HistoryRecord> records, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
    }

    private void createRelationshipEntries(Map<Long, List<HistoryEntry>> entriesMap, List<? extends HistoryRelationshipRecord> records, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        ArrayList<? extends HistoryRelationshipRecord> sortedRecords = new ArrayList<HistoryRelationshipRecord>(records);
        sortedRecords.sort(Comparator.comparing(HistoryRecord::getValidFrom).thenComparing(HistoryRecord::getValidTo, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(HistoryRelationshipRecord::getRelationType).thenComparing(HistoryRelationshipRecord::getRelatedObjectId).thenComparing(ObjectBaseRecord::getId));
        for (HistoryRelationshipRecord historyRelationshipRecord : sortedRecords) {
            List<HistoryEntry> entries = entriesMap.get(historyRelationshipRecord.objectId);
            if (entries == null) {
                entries = new LinkedList<HistoryEntry>();
                entriesMap.put(historyRelationshipRecord.objectId, entries);
            }
            entries.add((HistoryEntry)this.createRelationshipEntry(historyRelationshipRecord, authorMap, fetchOptions));
        }
    }

    protected RelationHistoryEntry createRelationshipEntry(HistoryRelationshipRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        RelationHistoryEntry entry = new RelationHistoryEntry();
        entry.setFetchOptions(new HistoryEntryFetchOptions());
        entry.setValidFrom(record.validFrom);
        entry.setValidTo(record.validTo);
        if (fetchOptions.hasAuthor()) {
            entry.setAuthor(authorMap.get(record.authorId));
            entry.getFetchOptions().withAuthorUsing(fetchOptions.withAuthor());
        }
        return entry;
    }

    protected boolean isDataSet(HistoryRelationshipRecord historyRelationshipRecord) {
        return this.isEntityKind("DATA SET", historyRelationshipRecord);
    }

    protected boolean isExperiment(HistoryRelationshipRecord historyRelationshipRecord) {
        return this.isEntityKind("EXPERIMENT", historyRelationshipRecord);
    }

    protected boolean isProject(HistoryRelationshipRecord historyRelationshipRecord) {
        return this.isEntityKind("PROJECT", historyRelationshipRecord);
    }

    protected boolean isSample(HistoryRelationshipRecord historyRelationshipRecord) {
        return this.isEntityKind("SAMPLE", historyRelationshipRecord);
    }

    protected boolean isSpace(HistoryRelationshipRecord historyRelationshipRecord) {
        return this.isEntityKind("SPACE", historyRelationshipRecord);
    }

    private boolean isEntityKind(String entityKind, HistoryRelationshipRecord historyRelationshipRecord) {
        return entityKind.equals(historyRelationshipRecord.entityKind);
    }
}

