/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.id.MaterialPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTagTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTypeRelationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.MaterialBaseRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialTranslator
extends AbstractCachingTranslator<Long, Material, MaterialFetchOptions>
implements IMaterialTranslator {
    @Autowired
    private IMaterialBaseTranslator baseTranslator;
    @Autowired
    private IMaterialTypeRelationTranslator typeTranslator;
    @Autowired
    private IMaterialPropertyTranslator propertyTranslator;
    @Autowired
    private IMaterialMaterialPropertyTranslator materialPropertyTranslator;
    @Autowired
    private IMaterialRegistratorTranslator registratorTranslator;
    @Autowired
    private IMaterialTagTranslator tagsTranslator;
    @Autowired
    private IMaterialHistoryTranslator historyTranslator;

    @Override
    protected Material createObject(TranslationContext context, Long materialId, MaterialFetchOptions fetchOptions) {
        Material material = new Material();
        material.setFetchOptions(new MaterialFetchOptions());
        return material;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> materialIds, MaterialFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IMaterialBaseTranslator.class, this.baseTranslator.translate(context, materialIds, null));
        if (fetchOptions.hasType()) {
            relations.put(IMaterialTypeRelationTranslator.class, this.typeTranslator.translate(context, materialIds, fetchOptions.withType()));
        }
        if (fetchOptions.hasProperties()) {
            relations.put(IMaterialPropertyTranslator.class, this.propertyTranslator.translate(context, materialIds, fetchOptions.withProperties()));
        }
        if (fetchOptions.hasMaterialProperties()) {
            relations.put(IMaterialMaterialPropertyTranslator.class, this.materialPropertyTranslator.translate(context, materialIds, fetchOptions.withMaterialProperties()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IMaterialRegistratorTranslator.class, this.registratorTranslator.translate(context, materialIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasTags()) {
            relations.put(IMaterialTagTranslator.class, this.tagsTranslator.translate(context, materialIds, fetchOptions.withTags()));
        }
        if (fetchOptions.hasHistory()) {
            relations.put(IMaterialHistoryTranslator.class, this.historyTranslator.translate(context, materialIds, fetchOptions.withHistory()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long materialId, Material result, Object objectRelations, MaterialFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        MaterialBaseRecord baseRecord = (MaterialBaseRecord)relations.get(IMaterialBaseTranslator.class, materialId);
        result.setPermId(new MaterialPermId(baseRecord.code, baseRecord.typeCode));
        result.setCode(baseRecord.code);
        result.setModificationDate(baseRecord.modificationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasType()) {
            result.setType((MaterialType)relations.get(IMaterialTypeRelationTranslator.class, materialId));
            result.getFetchOptions().withTypeUsing(fetchOptions.withType());
        }
        if (fetchOptions.hasProperties()) {
            result.setProperties((Map)relations.get(IMaterialPropertyTranslator.class, materialId));
            result.getFetchOptions().withPropertiesUsing(fetchOptions.withProperties());
        }
        if (fetchOptions.hasMaterialProperties()) {
            result.setMaterialProperties((Map)relations.get(IMaterialMaterialPropertyTranslator.class, materialId));
            result.getFetchOptions().withMaterialPropertiesUsing(fetchOptions.withMaterialProperties());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IMaterialRegistratorTranslator.class, materialId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasTags()) {
            result.setTags((Set)relations.get(IMaterialTagTranslator.class, materialId));
            result.getFetchOptions().withTagsUsing(fetchOptions.withTags());
        }
        if (fetchOptions.hasHistory()) {
            result.setHistory((List)relations.get(IMaterialHistoryTranslator.class, materialId));
            result.getFetchOptions().withHistoryUsing(fetchOptions.withHistory());
        }
    }
}

