/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialPropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTypeBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTypeValidationPluginTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.MaterialTypeBaseRecord;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaterialTypeTranslator
extends AbstractCachingTranslator<Long, MaterialType, MaterialTypeFetchOptions>
implements IMaterialTypeTranslator {
    @Autowired
    private IMaterialTypeBaseTranslator baseTranslator;
    @Autowired
    private IMaterialPropertyAssignmentTranslator assignmentTranslator;
    @Autowired
    private IMaterialTypeValidationPluginTranslator validationPluginTranslator;

    @Override
    protected MaterialType createObject(TranslationContext context, Long typeId, MaterialTypeFetchOptions fetchOptions) {
        MaterialType materialType = new MaterialType();
        materialType.setFetchOptions(fetchOptions);
        return materialType;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> typeIds, MaterialTypeFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IMaterialTypeBaseTranslator.class, this.baseTranslator.translate(context, typeIds, null));
        if (fetchOptions.hasPropertyAssignments()) {
            relations.put(IMaterialPropertyAssignmentTranslator.class, this.assignmentTranslator.translate(context, typeIds, fetchOptions.withPropertyAssignments()));
        }
        if (fetchOptions.hasValidationPlugin()) {
            relations.put(IMaterialTypeValidationPluginTranslator.class, this.validationPluginTranslator.translate(context, typeIds, fetchOptions.withValidationPlugin()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long typeId, MaterialType result, Object objectRelations, MaterialTypeFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        MaterialTypeBaseRecord baseRecord = (MaterialTypeBaseRecord)relations.get(IMaterialTypeBaseTranslator.class, typeId);
        result.setPermId(new EntityTypePermId(baseRecord.code, EntityKind.MATERIAL));
        result.setCode(baseRecord.code);
        result.setDescription(baseRecord.description);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasPropertyAssignments()) {
            result.setPropertyAssignments((List)relations.get(IMaterialPropertyAssignmentTranslator.class, typeId));
        }
        if (fetchOptions.hasValidationPlugin()) {
            result.setValidationPlugin((Plugin)relations.get(IMaterialTypeValidationPluginTranslator.class, typeId));
        }
    }
}

