/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IDate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ModificationDateSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.RegistrationDateSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.TechIdSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractEntityAttributeProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;

public class MaterialAttributeProvider
extends AbstractEntityAttributeProvider {
    @Override
    public IAttributeSearchFieldKind getAttribute(ISearchCriteria criteria) {
        if (criteria instanceof TechIdSearchCriteria) {
            return MaterialAttributeSearchFieldKind.ID;
        }
        if (criteria instanceof CodeSearchCriteria || criteria instanceof CodesSearchCriteria) {
            return MaterialAttributeSearchFieldKind.CODE;
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return MaterialAttributeSearchFieldKind.PERM_ID;
        }
        if (criteria instanceof RegistrationDateSearchCriteria) {
            RegistrationDateSearchCriteria dateCriteria = (RegistrationDateSearchCriteria)criteria;
            return this.getDateAttribute((IDate)dateCriteria.getFieldValue(), MaterialAttributeSearchFieldKind.REGISTRATION_DATE, MaterialAttributeSearchFieldKind.REGISTRATION_DATE_UNTIL, MaterialAttributeSearchFieldKind.REGISTRATION_DATE_FROM);
        }
        if (criteria instanceof ModificationDateSearchCriteria) {
            ModificationDateSearchCriteria dateCriteria = (ModificationDateSearchCriteria)criteria;
            return this.getDateAttribute((IDate)dateCriteria.getFieldValue(), MaterialAttributeSearchFieldKind.MODIFICATION_DATE, MaterialAttributeSearchFieldKind.MODIFICATION_DATE_UNTIL, MaterialAttributeSearchFieldKind.MODIFICATION_DATE_FROM);
        }
        throw new IllegalArgumentException("Unknown attribute criteria: " + criteria);
    }
}

