/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.id.PersonPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonRoleAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonSpaceTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonWebAppSettingsTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.PersonBaseRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonTranslator
extends AbstractCachingTranslator<Long, Person, PersonFetchOptions>
implements IPersonTranslator {
    @Autowired
    private IPersonBaseTranslator baseTranslator;
    @Autowired
    private IPersonSpaceTranslator spaceTranslator;
    @Autowired
    private IPersonRegistratorTranslator registratorTranslator;
    @Autowired
    private IPersonRoleAssignmentTranslator roleAssignmentTranslator;
    @Autowired
    private IPersonWebAppSettingsTranslator webAppSettingsTranslator;

    @Override
    protected Person createObject(TranslationContext context, Long personId, PersonFetchOptions fetchOptions) {
        Person result = new Person();
        result.setFetchOptions(new PersonFetchOptions());
        return result;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> personIds, PersonFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IPersonBaseTranslator.class, this.baseTranslator.translate(context, personIds, null));
        if (fetchOptions.hasSpace()) {
            relations.put(IPersonSpaceTranslator.class, this.spaceTranslator.translate(context, personIds, fetchOptions.withSpace()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IPersonRegistratorTranslator.class, this.registratorTranslator.translate(context, personIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasRoleAssignments()) {
            relations.put(IPersonRoleAssignmentTranslator.class, this.roleAssignmentTranslator.translate(context, personIds, fetchOptions.withRoleAssignments()));
        }
        if (fetchOptions.hasAllWebAppSettings() || fetchOptions.getWebAppSettings() != null && !fetchOptions.getWebAppSettings().isEmpty()) {
            relations.put(IPersonWebAppSettingsTranslator.class, this.webAppSettingsTranslator.translate(context, personIds, fetchOptions));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long personId, Person result, Object objectRelations, PersonFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        PersonBaseRecord baseRecord = (PersonBaseRecord)relations.get(IPersonBaseTranslator.class, personId);
        result.setFirstName(baseRecord.firstName);
        result.setLastName(baseRecord.lastName);
        result.setUserId(baseRecord.userId);
        result.setPermId(new PersonPermId(baseRecord.userId));
        result.setEmail(baseRecord.email);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setActive(baseRecord.isActive);
        if (fetchOptions.hasSpace()) {
            result.setSpace((Space)relations.get(IPersonSpaceTranslator.class, personId));
            result.getFetchOptions().withSpaceUsing(fetchOptions.withSpace());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IPersonRegistratorTranslator.class, personId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasRoleAssignments()) {
            result.setRoleAssignments((List)relations.get(IPersonRoleAssignmentTranslator.class, personId));
            result.getFetchOptions().withRoleAssignmentsUsing(fetchOptions.withRoleAssignments());
        }
        if (fetchOptions.hasAllWebAppSettings() || fetchOptions.getWebAppSettings() != null && !fetchOptions.getWebAppSettings().isEmpty()) {
            result.setWebAppSettings((Map)relations.get(IPersonWebAppSettingsTranslator.class, personId));
            result.getFetchOptions().withWebAppSettingsUsing(fetchOptions.getWebAppSettings());
            result.getFetchOptions().withAllWebAppSettingsUsing(fetchOptions.hasAllWebAppSettings());
        }
    }
}

