/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.fetchoptions.PersonFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSetting;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment.RoleAssignmentUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonWebAppSettingsTranslator;
import ch.systemsx.cisd.openbis.generic.server.DisplaySettingsProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonWebAppSettingsTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<Map<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings>>, PersonFetchOptions>
implements IPersonWebAppSettingsTranslator {
    @Autowired
    private DisplaySettingsProvider displaySettingsProvider;
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected ObjectHolder<Map<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings>> createObject(TranslationContext context, Long personId, PersonFetchOptions fetchOptions) {
        return new ObjectHolder<Map<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings>>();
    }

    @Override
    protected void updateObject(TranslationContext context, Long personId, ObjectHolder<Map<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings>> result, Object relations, PersonFetchOptions fetchOptions) {
        PersonPE person = (PersonPE)this.daoFactory.getPersonDAO().getByTechId(new TechId(personId));
        if (person == null) {
            return;
        }
        PersonPE loggedInPerson = context.getSession().tryGetPerson();
        if (!person.equals(loggedInPerson) && !RoleAssignmentUtils.isInstanceAdmin(loggedInPerson)) {
            return;
        }
        Collection<String> webAppIds = this.displaySettingsProvider.getWebAppIds(person);
        HashMap<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings> webAppSettingsMap = new HashMap<String, ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings>();
        for (String webAppId : webAppIds) {
            WebAppSettingsFetchOptions webAppFetchOptions;
            if (!fetchOptions.hasAllWebAppSettings() && !fetchOptions.hasWebAppSettings(webAppId)) continue;
            if (fetchOptions.hasWebAppSettings(webAppId)) {
                webAppFetchOptions = fetchOptions.withWebAppSettings(webAppId);
            } else {
                webAppFetchOptions = new WebAppSettingsFetchOptions();
                webAppFetchOptions.withAllSettings();
            }
            WebAppSettings settingsV1 = this.displaySettingsProvider.getWebAppSettings(person, webAppId);
            ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings webAppSettings = new ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings();
            webAppSettings.setWebAppId(webAppId);
            webAppSettings.setFetchOptions(webAppFetchOptions);
            if (webAppFetchOptions.hasAllSettings() || webAppFetchOptions.getSettings() != null && !webAppFetchOptions.getSettings().isEmpty()) {
                HashMap<String, WebAppSetting> settingsMap = new HashMap<String, WebAppSetting>();
                if (settingsV1.getSettings() != null) {
                    for (Map.Entry entry : settingsV1.getSettings().entrySet()) {
                        if (!webAppFetchOptions.hasAllSettings() && !webAppFetchOptions.hasSetting((String)entry.getKey())) continue;
                        settingsMap.put((String)entry.getKey(), new WebAppSetting((String)entry.getKey(), (String)entry.getValue()));
                    }
                }
                webAppSettings.setSettings(settingsMap);
            }
            webAppSettingsMap.put(webAppId, webAppSettings);
        }
        result.setObject(webAppSettingsMap);
    }
}

