/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.fetchoptions.PluginFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.PluginPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin.IPluginBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin.IPluginRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin.IPluginTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin.PluginRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.ICommonPropertyBasedHotDeployPlugin;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginTranslator
extends AbstractCachingTranslator<Long, Plugin, PluginFetchOptions>
implements IPluginTranslator {
    @Autowired
    private IPluginBaseTranslator baseTranslator;
    @Autowired
    private IPluginRegistratorTranslator registratorTranslator;
    @Resource(name="entity-validation-factory")
    private IEntityValidatorFactory entityValidationFactory;
    @Resource(name="dynamic-property-calculator-factory")
    private IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    @Override
    protected Plugin createObject(TranslationContext context, Long pluginId, PluginFetchOptions fetchOptions) {
        Plugin plugin = new Plugin();
        plugin.setFetchOptions(fetchOptions);
        return plugin;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> ids, PluginFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IPluginBaseTranslator.class, this.baseTranslator.translate(context, ids, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IPluginRegistratorTranslator.class, this.registratorTranslator.translate(context, ids, fetchOptions.withRegistrator()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long pluginId, Plugin plugin, Object objectRelations, PluginFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        PluginRecord baseRecord = (PluginRecord)relations.get(IPluginBaseTranslator.class, pluginId);
        plugin.setName(baseRecord.name);
        plugin.setPermId(new PluginPermId(baseRecord.name));
        plugin.setDescription(baseRecord.description);
        plugin.setRegistrationDate(baseRecord.registration_timestamp);
        plugin.setAvailable(baseRecord.is_available);
        if (baseRecord.entity_kind != null) {
            plugin.setEntityKinds(EnumSet.of(EntityKind.valueOf((String)baseRecord.entity_kind)));
        } else {
            plugin.setEntityKinds(EnumSet.allOf(EntityKind.class));
        }
        plugin.setPluginKind(PluginKind.valueOf((String)baseRecord.plugin_type));
        plugin.setPluginType(PluginType.valueOf((String)baseRecord.script_type));
        this.injectEntityKindsFromPredeployed(plugin);
        if (fetchOptions.hasScript()) {
            plugin.setScript(baseRecord.script);
            plugin.getFetchOptions().withScriptUsing(fetchOptions.withScript());
        }
        if (fetchOptions.hasRegistrator()) {
            plugin.setRegistrator((Person)relations.get(IPluginRegistratorTranslator.class, pluginId));
            plugin.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
    }

    private void injectEntityKindsFromPredeployed(Plugin plugin) {
        if (plugin.getPluginKind() == PluginKind.PREDEPLOYED) {
            ICommonPropertyBasedHotDeployPlugin hotDeployPlugin = null;
            switch (plugin.getPluginType()) {
                case ENTITY_VALIDATION: {
                    hotDeployPlugin = this.entityValidationFactory.tryGetPredeployedPluginByName(plugin.getName());
                    break;
                }
                case DYNAMIC_PROPERTY: {
                    hotDeployPlugin = this.dynamicPropertyCalculatorFactory.tryGetPredeployedPluginByName(plugin.getName());
                    break;
                }
                case MANAGED_PROPERTY: {
                    hotDeployPlugin = this.managedPropertyEvaluatorFactory.tryGetPredeployedPluginByName(plugin.getName());
                }
            }
            if (hotDeployPlugin != null) {
                EnumSet<ICommonPropertyBasedHotDeployPlugin.EntityKind> supportedEntityKinds = hotDeployPlugin.getSupportedEntityKinds();
                plugin.setEntityKinds(PluginTranslator.translateEntityKinds(supportedEntityKinds));
            }
        }
    }

    private static Set<EntityKind> translateEntityKinds(EnumSet<ICommonPropertyBasedHotDeployPlugin.EntityKind> entityKinds) {
        if (entityKinds == null) {
            return null;
        }
        ArrayList<EntityKind> kinds = new ArrayList<EntityKind>(entityKinds.size());
        for (ICommonPropertyBasedHotDeployPlugin.EntityKind kind : entityKinds) {
            kinds.add(EntityKind.valueOf((String)kind.name()));
        }
        return EnumSet.copyOf(kinds);
    }
}

