/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.ProjectAuthorizationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.ProjectQuery;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectAuthorizationValidator
implements IProjectAuthorizationValidator {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    public Set<Long> validate(PersonPE person, Collection<Long> projectIds) {
        ProjectQuery query = (ProjectQuery)QueryTool.getManagedQuery(ProjectQuery.class);
        List<ProjectAuthorizationRecord> records = query.getAuthorizations((LongSet)new LongOpenHashSet(projectIds));
        ProjectByIdentiferValidator validator = new ProjectByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        HashSet<Long> result = new HashSet<Long>();
        for (ProjectAuthorizationRecord record : records) {
            final ProjectAuthorizationRecord theRecord = record;
            if (!validator.doValidation(person, new IIdentifierHolder(){

                public String getIdentifier() {
                    return new ProjectIdentifier(theRecord.spaceCode, theRecord.code).getIdentifier();
                }
            })) continue;
            result.add(record.id);
        }
        return result;
    }
}

