/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.IRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.id.UnknownRelatedObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.history.ProjectRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.ProjectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.ProjectRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceAuthorizationValidator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectHistoryTranslator
extends HistoryTranslator
implements IProjectHistoryTranslator {
    @Autowired
    private ISpaceAuthorizationValidator spaceValidator;
    @Autowired
    private IExperimentAuthorizationValidator experimentValidator;
    @Autowired
    private ISampleAuthorizationValidator sampleValidator;

    @Override
    protected List<? extends PropertyRecord> loadProperties(Collection<Long> entityIds) {
        return null;
    }

    protected List<HistoryPropertyRecord> loadPropertyHistory(Collection<Long> entityIds) {
        return null;
    }

    @Override
    protected List<? extends HistoryRelationshipRecord> loadRelationshipHistory(TranslationContext context, Collection<Long> entityIds) {
        ProjectQuery query = (ProjectQuery)QueryTool.getManagedQuery(ProjectQuery.class);
        List<ProjectRelationshipRecord> records = query.getRelationshipsHistory((LongSet)new LongOpenHashSet(entityIds));
        ArrayList<ProjectRelationshipRecord> validRecords = new ArrayList<ProjectRelationshipRecord>();
        Set<Long> spaceIds = new HashSet<Long>();
        Set<Long> experimentIds = new HashSet<Long>();
        Set<Long> sampleIds = new HashSet<Long>();
        for (ProjectRelationshipRecord record : records) {
            if (record.spaceId != null) {
                spaceIds.add(record.spaceId);
                continue;
            }
            if (record.experimentId != null) {
                experimentIds.add(record.experimentId);
                continue;
            }
            if (record.sampleId == null) continue;
            sampleIds.add(record.sampleId);
        }
        if (!spaceIds.isEmpty()) {
            spaceIds = this.spaceValidator.validate(context.getSession().tryGetPerson(), spaceIds);
        }
        if (!experimentIds.isEmpty()) {
            experimentIds = this.experimentValidator.validate(context.getSession().tryGetPerson(), experimentIds);
        }
        if (!sampleIds.isEmpty()) {
            sampleIds = this.sampleValidator.validate(context.getSession().tryGetPerson(), sampleIds);
        }
        boolean isSystemUser = context.getSession().tryGetPerson() != null && context.getSession().tryGetPerson().isSystemUser();
        for (ProjectRelationshipRecord record : records) {
            boolean isValid = false;
            isValid = record.spaceId != null ? spaceIds.contains(record.spaceId) : (record.experimentId != null ? experimentIds.contains(record.experimentId) : (record.sampleId != null ? sampleIds.contains(record.sampleId) : isSystemUser));
            if (!isValid) continue;
            validRecords.add(record);
        }
        return validRecords;
    }

    @Override
    protected RelationHistoryEntry createRelationshipEntry(HistoryRelationshipRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        RelationHistoryEntry entry = super.createRelationshipEntry(record, authorMap, fetchOptions);
        ProjectRelationshipRecord projectRecord = (ProjectRelationshipRecord)record;
        if (this.isSpace(projectRecord)) {
            entry.setRelationType((IRelationType)ProjectRelationType.SPACE);
            entry.setRelatedObjectId((IObjectId)new SpacePermId(projectRecord.relatedObjectId));
        } else if (this.isExperiment(projectRecord)) {
            entry.setRelationType((IRelationType)ProjectRelationType.EXPERIMENT);
            entry.setRelatedObjectId((IObjectId)new ExperimentPermId(projectRecord.relatedObjectId));
        } else if (this.isSample(projectRecord)) {
            entry.setRelationType((IRelationType)ProjectRelationType.SAMPLE);
            entry.setRelatedObjectId((IObjectId)new SamplePermId(projectRecord.relatedObjectId));
        } else {
            entry.setRelatedObjectId((IObjectId)new UnknownRelatedObjectId(projectRecord.relatedObjectId, projectRecord.relationType));
        }
        return entry;
    }
}

