/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectAttachmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectLeaderTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectModifierTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectSampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectSpaceTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.ProjectBaseRecord;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectTranslator
extends AbstractCachingTranslator<Long, Project, ProjectFetchOptions>
implements IProjectTranslator {
    @Autowired
    private IProjectAuthorizationValidator authorizationValidator;
    @Autowired
    private IProjectBaseTranslator baseTranslator;
    @Autowired
    private IProjectSpaceTranslator spaceTranslator;
    @Autowired
    private IProjectExperimentTranslator experimentTranslator;
    @Autowired
    private IProjectSampleTranslator sampleTranslator;
    @Autowired
    private IProjectRegistratorTranslator registratorTranslator;
    @Autowired
    private IProjectModifierTranslator modifierTranslator;
    @Autowired
    private IProjectLeaderTranslator leaderTranslator;
    @Autowired
    private IProjectAttachmentTranslator attachmentTranslator;
    @Autowired
    private IProjectHistoryTranslator historyTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> projectIds, ProjectFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), projectIds);
    }

    @Override
    protected Project createObject(TranslationContext context, Long projectId, ProjectFetchOptions fetchOptions) {
        Project project = new Project();
        project.setFetchOptions(new ProjectFetchOptions());
        return project;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> projectIds, ProjectFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IProjectBaseTranslator.class, this.baseTranslator.translate(context, projectIds, null));
        if (fetchOptions.hasSpace()) {
            relations.put(IProjectSpaceTranslator.class, this.spaceTranslator.translate(context, projectIds, fetchOptions.withSpace()));
        }
        if (fetchOptions.hasExperiments()) {
            relations.put(IProjectExperimentTranslator.class, this.experimentTranslator.translate(context, projectIds, fetchOptions.withExperiments()));
        }
        if (fetchOptions.hasSamples()) {
            relations.put(IProjectSampleTranslator.class, this.sampleTranslator.translate(context, projectIds, fetchOptions.withSamples()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IProjectRegistratorTranslator.class, this.registratorTranslator.translate(context, projectIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasModifier()) {
            relations.put(IProjectModifierTranslator.class, this.modifierTranslator.translate(context, projectIds, fetchOptions.withModifier()));
        }
        if (fetchOptions.hasLeader()) {
            relations.put(IProjectLeaderTranslator.class, this.leaderTranslator.translate(context, projectIds, fetchOptions.withLeader()));
        }
        if (fetchOptions.hasAttachments()) {
            relations.put(IProjectAttachmentTranslator.class, this.attachmentTranslator.translate(context, projectIds, fetchOptions.withAttachments()));
        }
        if (fetchOptions.hasHistory()) {
            relations.put(IProjectHistoryTranslator.class, this.historyTranslator.translate(context, projectIds, fetchOptions.withHistory()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long projectId, Project result, Object objectRelations, ProjectFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        ProjectBaseRecord baseRecord = (ProjectBaseRecord)relations.get(IProjectBaseTranslator.class, projectId);
        result.setCode(baseRecord.code);
        result.setPermId(new ProjectPermId(baseRecord.permId));
        result.setIdentifier(new ProjectIdentifier(baseRecord.spaceCode, baseRecord.code));
        result.setDescription(baseRecord.description);
        result.setFrozen(baseRecord.frozen);
        result.setFrozenForExperiments(baseRecord.frozenForExperiments);
        result.setFrozenForSamples(baseRecord.frozenForSamples);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasSpace()) {
            result.setSpace((Space)relations.get(IProjectSpaceTranslator.class, projectId));
            result.getFetchOptions().withSpaceUsing(fetchOptions.withSpace());
        }
        if (fetchOptions.hasExperiments()) {
            result.setExperiments((List)relations.get(IProjectExperimentTranslator.class, projectId));
            result.getFetchOptions().withExperimentsUsing(fetchOptions.withExperiments());
        }
        if (fetchOptions.hasSamples()) {
            result.setSamples(SampleUtils.extractSamples((Collection)relations.get(IProjectSampleTranslator.class, projectId)));
            result.getFetchOptions().withSamplesUsing(fetchOptions.withSamples());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IProjectRegistratorTranslator.class, projectId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasModifier()) {
            result.setModifier((Person)relations.get(IProjectModifierTranslator.class, projectId));
            result.getFetchOptions().withModifierUsing(fetchOptions.withModifier());
        }
        if (fetchOptions.hasLeader()) {
            result.setLeader((Person)relations.get(IProjectLeaderTranslator.class, projectId));
            result.getFetchOptions().withLeaderUsing(fetchOptions.withLeader());
        }
        if (fetchOptions.hasAttachments()) {
            result.setAttachments((List)relations.get(IProjectAttachmentTranslator.class, projectId));
            result.getFetchOptions().withAttachmentsUsing(fetchOptions.withAttachments());
        }
        if (fetchOptions.hasHistory()) {
            result.setHistory((List)relations.get(IProjectHistoryTranslator.class, projectId));
            result.getFetchOptions().withHistoryUsing(fetchOptions.withHistory());
        }
    }
}

