/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractCompositeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.NoProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.ProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldFromCompositeSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchObjectKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SimpleAttributeSearchFieldKind;
import java.util.Collection;
import java.util.EnumSet;

public class ProjectSearchCriteriaTranslator
extends AbstractFieldFromCompositeSearchCriteriaTranslator {
    private static final DetailedSearchField PROJECT_ID_FIELD = DetailedSearchField.createAttributeField(new SimpleAttributeSearchFieldKind("project id", "Project ID"));

    public ProjectSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof NoProjectSearchCriteria || criteria instanceof ProjectSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        if (!EnumSet.of(SearchObjectKind.EXPERIMENT, SearchObjectKind.SAMPLE).contains((Object)context.peekObjectKind())) {
            throw new IllegalArgumentException("Project criteria can be used only in experiment or sample criteria, but was used in: " + (Object)((Object)context.peekObjectKind()) + " context.");
        }
        if (criteria instanceof NoProjectSearchCriteria) {
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(PROJECT_ID_FIELD, "NULL"));
        }
        AbstractCompositeSearchCriteria compositeCriteria = (AbstractCompositeSearchCriteria)criteria;
        Collection subCriteria = compositeCriteria.getCriteria();
        if (subCriteria.isEmpty()) {
            DetailedSearchCriterion criterion = new DetailedSearchCriterion(PROJECT_ID_FIELD, "NULL");
            criterion.negate();
            return new SearchCriteriaTranslationResult(criterion);
        }
        return super.doTranslate(context, criteria);
    }

    @Override
    protected DetailedSearchField doTranslateSearchField(SearchTranslationContext context, ISearchCriteria criteria, ISearchCriteria subCriteria) {
        SearchObjectKind objectKind = context.peekObjectKind();
        if (subCriteria instanceof CodeSearchCriteria) {
            return DetailedSearchField.createAttributeField((IAttributeSearchFieldKind)((Object)(objectKind == SearchObjectKind.EXPERIMENT ? ExperimentAttributeSearchFieldKind.PROJECT : SampleAttributeSearchFieldKind.PROJECT)));
        }
        if (subCriteria instanceof PermIdSearchCriteria) {
            return DetailedSearchField.createAttributeField((IAttributeSearchFieldKind)((Object)(objectKind == SearchObjectKind.EXPERIMENT ? ExperimentAttributeSearchFieldKind.PROJECT_PERM_ID : SampleAttributeSearchFieldKind.PROJECT_PERM_ID)));
        }
        if (subCriteria instanceof SpaceSearchCriteria) {
            return DetailedSearchField.createAttributeField((IAttributeSearchFieldKind)((Object)(objectKind == SearchObjectKind.EXPERIMENT ? ExperimentAttributeSearchFieldKind.PROJECT_SPACE : SampleAttributeSearchFieldKind.PROJECT_SPACE)));
        }
        throw new IllegalArgumentException("Unknown criteria: " + subCriteria);
    }
}

