/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.MaterialPropertyRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MaterialPropertyTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<Map<String, Material>>, MaterialFetchOptions>
implements IMaterialPropertyTranslator {
    @Autowired
    private IMaterialTranslator materialTranslator;

    @Override
    protected ObjectHolder<Map<String, Material>> createObject(TranslationContext context, Long objectId, MaterialFetchOptions fetchOptions) {
        return new ObjectHolder<Map<String, Material>>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> objectIds, MaterialFetchOptions fetchOptions) {
        List<MaterialPropertyRecord> records = this.loadMaterialProperties(objectIds);
        HashSet<Long> propertyValues = new HashSet<Long>();
        for (MaterialPropertyRecord record : records) {
            propertyValues.add(record.propertyValue);
        }
        Map materials = this.materialTranslator.translate(context, propertyValues, fetchOptions);
        HashMap<Long, HashMap<String, Material>> materialProperties = new HashMap<Long, HashMap<String, Material>>();
        for (MaterialPropertyRecord record : records) {
            HashMap<String, Material> properties = (HashMap<String, Material>)materialProperties.get(record.objectId);
            if (properties == null) {
                properties = new HashMap<String, Material>();
                materialProperties.put(record.objectId, properties);
            }
            properties.put(record.propertyCode, (Material)materials.get(record.propertyValue));
        }
        return materialProperties;
    }

    @Override
    protected void updateObject(TranslationContext context, Long objectId, ObjectHolder<Map<String, Material>> result, Object relations, MaterialFetchOptions fetchOptions) {
        Map materialProperties = (Map)relations;
        HashMap objectProperties = (HashMap)materialProperties.get(objectId);
        if (objectProperties == null) {
            objectProperties = new HashMap();
        }
        result.setObject(objectProperties);
    }

    protected abstract List<MaterialPropertyRecord> loadMaterialProperties(Collection<Long> var1);
}

