/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.fetchoptions.MaterialTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyAssignmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyAssignmentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.material.IMaterialTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.person.IPersonTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.plugin.IPluginTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyAssignmentKey;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyAssignmentRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationTranslator;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PropertyAssignmentTranslator
implements IPropertyAssignmentTranslator {
    @Autowired
    private IPropertyTypeTranslator propertyTypeTranslator;
    @Autowired
    private IMaterialTypeTranslator materialTypeTranslator;
    @Autowired
    private IExperimentTypeTranslator experimentTypeTranslator;
    @Autowired
    private ISampleTypeTranslator sampleTypeTranslator;
    @Autowired
    private IDataSetTypeTranslator dataSetTypeTranslator;
    @Autowired
    private ISemanticAnnotationTranslator annotationTranslator;
    @Autowired
    private IPersonTranslator personTranslator;
    @Autowired
    private IPluginTranslator pluginTranslator;

    @Override
    public Map<Long, PropertyAssignment> getIdToAssignmentMap(TranslationContext context, Collection<PropertyAssignmentRecord> assignmentRecords, PropertyAssignmentFetchOptions assignmentFetchOptions) {
        Map<PropertyAssignmentKey, PropertyAssignment> keyToAssignmentMap = this.getKeyToAssignmentMap(context, assignmentRecords, assignmentFetchOptions);
        HashMap<Long, PropertyAssignment> idToAssignmentMap = new HashMap<Long, PropertyAssignment>();
        for (Map.Entry<PropertyAssignmentKey, PropertyAssignment> entry : keyToAssignmentMap.entrySet()) {
            idToAssignmentMap.put(entry.getKey().getId(), entry.getValue());
        }
        return idToAssignmentMap;
    }

    @Override
    public Map<PropertyAssignmentKey, PropertyAssignment> getKeyToAssignmentMap(TranslationContext context, Collection<PropertyAssignmentRecord> assignmentRecords, PropertyAssignmentFetchOptions assignmentFetchOptions) {
        Map registratorMap;
        HashMap<PropertyAssignmentKey, PropertyAssignment> assignments = new HashMap<PropertyAssignmentKey, PropertyAssignment>();
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            EntityKind entityKind = EntityKind.valueOf((String)assignmentRecord.kind_code);
            EntityTypePermId entityTypeId = new EntityTypePermId(assignmentRecord.type_code, entityKind);
            PropertyTypePermId propertyTypeId = new PropertyTypePermId(CodeConverter.tryToBusinessLayer(assignmentRecord.prty_code, assignmentRecord.prty_is_managed_internally));
            PropertyAssignment assignment = new PropertyAssignment();
            assignment.setPermId(new PropertyAssignmentPermId((IEntityTypeId)entityTypeId, (IPropertyTypeId)propertyTypeId));
            assignment.setSection(assignmentRecord.section);
            assignment.setOrdinal(assignmentRecord.ordinal);
            assignment.setMandatory(assignmentRecord.is_mandatory);
            assignment.setShowInEditView(assignmentRecord.is_shown_edit);
            assignment.setShowRawValueInForms(assignmentRecord.show_raw_value);
            assignment.setSemanticAnnotationsInherited(Boolean.valueOf(false));
            assignment.setRegistrationDate(assignmentRecord.registration_timestamp);
            assignment.setFetchOptions(assignmentFetchOptions);
            PropertyAssignmentKey key = new PropertyAssignmentKey(assignmentRecord.id, entityKind);
            assignments.put(key, assignment);
        }
        if (assignmentFetchOptions.getSortBy() != null && (assignmentFetchOptions.getSortBy().getCode() != null || assignmentFetchOptions.getSortBy().getLabel() != null)) {
            assignmentFetchOptions.withPropertyType();
        }
        if (assignmentFetchOptions.hasEntityType()) {
            this.setEntityTypes(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.MATERIAL);
            this.setEntityTypes(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.EXPERIMENT);
            this.setEntityTypes(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.SAMPLE);
            this.setEntityTypes(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.DATA_SET);
        }
        if (assignmentFetchOptions.hasPropertyType()) {
            Map<Long, List<PropertyAssignment>> assignmentsByPropertyTypeId = this.getAssignments(assignments, assignmentRecords, r -> r.prty_id);
            Map propertyTypeMap = this.propertyTypeTranslator.translate(context, assignmentsByPropertyTypeId.keySet(), assignmentFetchOptions.withPropertyType());
            for (Map.Entry<Long, List<PropertyAssignment>> entry : assignmentsByPropertyTypeId.entrySet()) {
                PropertyType propertyType = (PropertyType)propertyTypeMap.get(entry.getKey());
                for (PropertyAssignment assignment : entry.getValue()) {
                    assignment.setPropertyType(propertyType);
                }
            }
        }
        if (assignmentFetchOptions.hasSemanticAnnotations()) {
            this.setSemanticAnnotations(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.SAMPLE);
        }
        if (assignmentFetchOptions.hasRegistrator()) {
            Map<Long, List<PropertyAssignment>> assignmentsByRegistatorId = this.getAssignments(assignments, assignmentRecords, r -> r.pers_id_registerer);
            registratorMap = this.personTranslator.translate(context, assignmentsByRegistatorId.keySet(), assignmentFetchOptions.withRegistrator());
            for (Map.Entry<Long, List<PropertyAssignment>> entry : assignmentsByRegistatorId.entrySet()) {
                Person registrator = (Person)registratorMap.get(entry.getKey());
                for (PropertyAssignment assignment : entry.getValue()) {
                    assignment.setRegistrator(registrator);
                }
            }
        }
        if (assignmentFetchOptions.hasPlugin()) {
            Map<Long, List<PropertyAssignment>> assignmentsByPluginId = this.getAssignments(assignments, assignmentRecords, r -> r.script_id);
            registratorMap = this.pluginTranslator.translate(context, assignmentsByPluginId.keySet(), assignmentFetchOptions.withPlugin());
            for (Map.Entry<Long, List<PropertyAssignment>> entry : assignmentsByPluginId.entrySet()) {
                Plugin plugin = (Plugin)registratorMap.get(entry.getKey());
                for (PropertyAssignment assignment : entry.getValue()) {
                    assignment.setPlugin(plugin);
                }
            }
        }
        return assignments;
    }

    private Map<Long, List<PropertyAssignment>> getAssignments(Map<PropertyAssignmentKey, PropertyAssignment> assignments, Collection<PropertyAssignmentRecord> assignmentRecords, Function<PropertyAssignmentRecord, Long> extractor) {
        HashMap<Long, List<PropertyAssignment>> map = new HashMap<Long, List<PropertyAssignment>>();
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            EntityKind entityKind = EntityKind.valueOf((String)assignmentRecord.kind_code);
            PropertyAssignmentKey key = new PropertyAssignmentKey(assignmentRecord.id, entityKind);
            PropertyAssignment assignment = assignments.get(key);
            Long id = extractor.apply(assignmentRecord);
            if (id == null) continue;
            ArrayList<PropertyAssignment> list = (ArrayList<PropertyAssignment>)map.get(id);
            if (list == null) {
                list = new ArrayList<PropertyAssignment>();
                map.put(id, list);
            }
            list.add(assignment);
        }
        return map;
    }

    private void setEntityTypes(TranslationContext context, Map<PropertyAssignmentKey, PropertyAssignment> assignments, Collection<PropertyAssignmentRecord> assignmentRecords, PropertyAssignmentFetchOptions assignmentFetchOptions, EntityKind entityKind) {
        HashMap<Long, ArrayList<PropertyAssignment>> assignmentsByEntityTypeId = new HashMap<Long, ArrayList<PropertyAssignment>>();
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            if (!entityKind.equals((Object)EntityKind.valueOf((String)assignmentRecord.kind_code))) continue;
            PropertyAssignmentKey key = new PropertyAssignmentKey(assignmentRecord.id, entityKind);
            PropertyAssignment assignment = assignments.get(key);
            ArrayList<PropertyAssignment> list = (ArrayList<PropertyAssignment>)assignmentsByEntityTypeId.get(assignmentRecord.type_id);
            if (list == null) {
                list = new ArrayList<PropertyAssignment>();
                assignmentsByEntityTypeId.put(assignmentRecord.type_id, list);
            }
            list.add(assignment);
        }
        Map entityTypeMap = null;
        if (entityKind.equals((Object)EntityKind.MATERIAL)) {
            MaterialTypeFetchOptions materialTypeFetchOptions = new MaterialTypeFetchOptions();
            if (assignmentFetchOptions.withEntityType().hasPropertyAssignments()) {
                materialTypeFetchOptions.withPropertyAssignments();
            }
            entityTypeMap = this.materialTypeTranslator.translate(context, assignmentsByEntityTypeId.keySet(), materialTypeFetchOptions);
        } else if (entityKind.equals((Object)EntityKind.EXPERIMENT)) {
            ExperimentTypeFetchOptions experimentTypeFetchOptions = new ExperimentTypeFetchOptions();
            if (assignmentFetchOptions.withEntityType().hasPropertyAssignments()) {
                experimentTypeFetchOptions.withPropertyAssignments();
            }
            entityTypeMap = this.experimentTypeTranslator.translate(context, assignmentsByEntityTypeId.keySet(), experimentTypeFetchOptions);
        } else if (entityKind.equals((Object)EntityKind.SAMPLE)) {
            SampleTypeFetchOptions sampleTypeFetchOptions = new SampleTypeFetchOptions();
            if (assignmentFetchOptions.withEntityType().hasPropertyAssignments()) {
                sampleTypeFetchOptions.withPropertyAssignments();
            }
            entityTypeMap = this.sampleTypeTranslator.translate(context, assignmentsByEntityTypeId.keySet(), sampleTypeFetchOptions);
        } else if (entityKind.equals((Object)EntityKind.DATA_SET)) {
            DataSetTypeFetchOptions dataSetTypeFetchOptions = new DataSetTypeFetchOptions();
            if (assignmentFetchOptions.withEntityType().hasPropertyAssignments()) {
                dataSetTypeFetchOptions.withPropertyAssignments();
            }
            entityTypeMap = this.dataSetTypeTranslator.translate(context, assignmentsByEntityTypeId.keySet(), dataSetTypeFetchOptions);
        } else {
            throw new IllegalArgumentException("Unsupported enity kind: " + entityKind);
        }
        for (Map.Entry entry : assignmentsByEntityTypeId.entrySet()) {
            IEntityType entityType = (IEntityType)entityTypeMap.get(entry.getKey());
            for (PropertyAssignment assignment : (List)entry.getValue()) {
                assignment.setEntityType(entityType);
            }
        }
    }

    private void setSemanticAnnotations(TranslationContext context, Map<PropertyAssignmentKey, PropertyAssignment> assignments, Collection<PropertyAssignmentRecord> assignmentRecords, PropertyAssignmentFetchOptions assignmentFetchOptions, EntityKind entityKind) {
        HashSet<Long> propertyAssignmentIds = new HashSet<Long>();
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            if (!entityKind.equals((Object)EntityKind.valueOf((String)assignmentRecord.kind_code))) continue;
            propertyAssignmentIds.add(assignmentRecord.id);
        }
        List<ObjectRelationRecord> assignmentToAnnotationRecords = null;
        if (entityKind.equals((Object)EntityKind.SAMPLE)) {
            SampleQuery sampleQuery = (SampleQuery)QueryTool.getManagedQuery(SampleQuery.class);
            assignmentToAnnotationRecords = sampleQuery.getPropertyAssignmentAnnotationIds((LongSet)new LongOpenHashSet(propertyAssignmentIds));
        }
        if (assignmentToAnnotationRecords != null) {
            HashSet<Long> annotationIds = new HashSet<Long>();
            for (ObjectRelationRecord assignmentToAnnotationRecord : assignmentToAnnotationRecords) {
                annotationIds.add(assignmentToAnnotationRecord.relatedId);
            }
            Map annotations = this.annotationTranslator.translate(context, annotationIds, assignmentFetchOptions.withSemanticAnnotations());
            for (ObjectRelationRecord assignmentToAnnotationRecord : assignmentToAnnotationRecords) {
                PropertyAssignmentKey key = new PropertyAssignmentKey(assignmentToAnnotationRecord.objectId, entityKind);
                PropertyAssignment assignment = assignments.get(key);
                SemanticAnnotation annotation = (SemanticAnnotation)annotations.get(assignmentToAnnotationRecord.relatedId);
                ArrayList<SemanticAnnotation> assignmentAnnotations = assignment.getSemanticAnnotations();
                if (assignmentAnnotations == null) {
                    assignmentAnnotations = new ArrayList<SemanticAnnotation>();
                    assignment.setSemanticAnnotations(assignmentAnnotations);
                }
                assignmentAnnotations.add(annotation);
            }
        }
        this.setSemanticAnnotationsFromPropertyTypeIfMissing(context, assignments, assignmentRecords, assignmentFetchOptions, EntityKind.SAMPLE);
    }

    private void setSemanticAnnotationsFromPropertyTypeIfMissing(TranslationContext context, Map<PropertyAssignmentKey, PropertyAssignment> assignments, Collection<PropertyAssignmentRecord> assignmentRecords, PropertyAssignmentFetchOptions assignmentFetchOptions, EntityKind entityKind) {
        HashSet<Long> propertyTypeIds = new HashSet<Long>();
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            if (!entityKind.equals((Object)EntityKind.valueOf((String)assignmentRecord.kind_code))) continue;
            propertyTypeIds.add(assignmentRecord.prty_id);
        }
        PropertyTypeFetchOptions propertyTypeFetchOptions = new PropertyTypeFetchOptions();
        propertyTypeFetchOptions.withSemanticAnnotations();
        Map propertyTypes = this.propertyTypeTranslator.translate(context, propertyTypeIds, propertyTypeFetchOptions);
        for (PropertyAssignmentRecord assignmentRecord : assignmentRecords) {
            PropertyAssignmentKey key;
            PropertyAssignment assignment;
            if (!entityKind.equals((Object)EntityKind.valueOf((String)assignmentRecord.kind_code)) || (assignment = assignments.get(key = new PropertyAssignmentKey(assignmentRecord.id, entityKind))).getSemanticAnnotations() != null && !assignment.getSemanticAnnotations().isEmpty()) continue;
            PropertyType propertyType = (PropertyType)propertyTypes.get(assignmentRecord.prty_id);
            assignment.setSemanticAnnotations(propertyType.getSemanticAnnotations());
            assignment.setSemanticAnnotationsInherited(Boolean.valueOf(true));
        }
    }
}

