/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PropertyTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<Map<String, String>>, PropertyFetchOptions>
implements IPropertyTranslator {
    @Autowired
    private ISampleAuthorizationValidator sampleAuthorizationValidator;

    @Override
    protected ObjectHolder<Map<String, String>> createObject(TranslationContext context, Long objectId, PropertyFetchOptions fetchOptions) {
        return new ObjectHolder<Map<String, String>>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> objectIds, PropertyFetchOptions fetchOptions) {
        List<PropertyRecord> records = this.loadProperties(objectIds);
        Set<Long> visibaleSamples = this.sampleAuthorizationValidator.validate(context.getSession().tryGetPerson(), records.stream().filter(r -> r.sample_id != null).map(r -> r.sample_id).collect(Collectors.toSet()));
        HashMap properties = new HashMap();
        for (PropertyRecord record : records) {
            HashMap<String, String> objectProperties = (HashMap<String, String>)properties.get(record.objectId);
            if (objectProperties == null) {
                objectProperties = new HashMap<String, String>();
                properties.put(record.objectId, objectProperties);
            }
            if (record.propertyValue != null) {
                objectProperties.put(record.propertyCode, record.propertyValue);
                continue;
            }
            if (record.materialPropertyValueCode != null) {
                objectProperties.put(record.propertyCode, record.materialPropertyValueCode + " (" + record.materialPropertyValueTypeCode + ")");
                continue;
            }
            if (record.vocabularyPropertyValue != null) {
                objectProperties.put(record.propertyCode, record.vocabularyPropertyValue);
                continue;
            }
            if (record.sample_perm_id == null || !visibaleSamples.contains(record.sample_id)) continue;
            objectProperties.put(record.propertyCode, record.sample_perm_id);
        }
        return properties;
    }

    @Override
    protected void updateObject(TranslationContext context, Long objectId, ObjectHolder<Map<String, String>> result, Object relations, PropertyFetchOptions fetchOptions) {
        Map properties = (Map)relations;
        HashMap objectProperties = (HashMap)properties.get(objectId);
        if (objectProperties == null) {
            objectProperties = new HashMap();
        }
        result.setObject(objectProperties);
    }

    protected abstract List<PropertyRecord> loadProperties(Collection<Long> var1);
}

