/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.MaterialType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.DataType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CommonUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeMaterialTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeSampleTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeSemanticAnnotationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.IPropertyTypeVocabularyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyTypeRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PropertyTypeTranslator
extends AbstractCachingTranslator<Long, PropertyType, PropertyTypeFetchOptions>
implements IPropertyTypeTranslator {
    @Autowired
    private IPropertyTypeBaseTranslator baseTranslator;
    @Autowired
    private IPropertyTypeVocabularyTranslator vocabularyTranslator;
    @Autowired
    private IPropertyTypeMaterialTypeTranslator materialTypeTranslator;
    @Autowired
    private IPropertyTypeSampleTypeTranslator sampleTypeTranslator;
    @Autowired
    private IPropertyTypeRegistratorTranslator registratorTranslator;
    @Autowired
    private IPropertyTypeSemanticAnnotationTranslator annotationTranslator;

    @Override
    protected PropertyType createObject(TranslationContext context, Long typeId, PropertyTypeFetchOptions fetchOptions) {
        PropertyType type = new PropertyType();
        type.setFetchOptions(fetchOptions);
        return type;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> typeIds, PropertyTypeFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IPropertyTypeBaseTranslator.class, this.baseTranslator.translate(context, typeIds, null));
        if (fetchOptions.hasVocabulary()) {
            relations.put(IPropertyTypeVocabularyTranslator.class, this.vocabularyTranslator.translate(context, typeIds, fetchOptions.withVocabulary()));
        }
        if (fetchOptions.hasMaterialType()) {
            relations.put(IPropertyTypeMaterialTypeTranslator.class, this.materialTypeTranslator.translate(context, typeIds, fetchOptions.withMaterialType()));
        }
        if (fetchOptions.hasSampleType()) {
            relations.put(IPropertyTypeSampleTypeTranslator.class, this.sampleTypeTranslator.translate(context, typeIds, fetchOptions.withSampleType()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(IPropertyTypeRegistratorTranslator.class, this.registratorTranslator.translate(context, typeIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasSemanticAnnotations()) {
            relations.put(IPropertyTypeSemanticAnnotationTranslator.class, this.annotationTranslator.translate(context, typeIds, fetchOptions.withSemanticAnnotations()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long typeId, PropertyType result, Object objectRelations, PropertyTypeFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        PropertyTypeRecord baseRecord = (PropertyTypeRecord)relations.get(IPropertyTypeBaseTranslator.class, typeId);
        String businessCode = CodeConverter.tryToBusinessLayer(baseRecord.code, baseRecord.is_managed_internally);
        result.setCode(businessCode);
        result.setPermId(new PropertyTypePermId(businessCode));
        result.setLabel(baseRecord.label);
        result.setDescription(baseRecord.description);
        result.setDataType(DataType.valueOf((String)baseRecord.data_type));
        result.setManagedInternally(baseRecord.is_managed_internally);
        result.setSchema(baseRecord.schema);
        result.setTransformation(baseRecord.transformation);
        result.setRegistrationDate(baseRecord.registration_timestamp);
        result.setMetaData(CommonUtils.asMap(baseRecord.meta_data));
        if (fetchOptions.hasVocabulary()) {
            result.setVocabulary((Vocabulary)relations.get(IPropertyTypeVocabularyTranslator.class, typeId));
            result.getFetchOptions().withVocabularyUsing(fetchOptions.withVocabulary());
        }
        if (fetchOptions.hasMaterialType()) {
            result.setMaterialType((MaterialType)relations.get(IPropertyTypeMaterialTypeTranslator.class, typeId));
            result.getFetchOptions().withMaterialTypeUsing(fetchOptions.withMaterialType());
        }
        if (fetchOptions.hasSampleType()) {
            result.setSampleType((SampleType)relations.get(IPropertyTypeSampleTypeTranslator.class, typeId));
            result.getFetchOptions().withSampleTypeUsing(fetchOptions.withSampleType());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IPropertyTypeRegistratorTranslator.class, typeId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasSemanticAnnotations()) {
            result.setSemanticAnnotations((List)relations.get(IPropertyTypeSemanticAnnotationTranslator.class, typeId));
            result.getFetchOptions().withSemanticAnnotationsUsing(fetchOptions.withSemanticAnnotations());
        }
    }
}

