/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectHolder;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.ISamplePropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.SamplePropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SamplePropertyTranslator
extends AbstractCachingTranslator<Long, ObjectHolder<Map<String, Sample>>, SampleFetchOptions>
implements ISamplePropertyTranslator {
    @Autowired
    private ISampleTranslator sampleTranslator;

    @Override
    protected ObjectHolder<Map<String, Sample>> createObject(TranslationContext context, Long objectId, SampleFetchOptions fetchOptions) {
        return new ObjectHolder<Map<String, Sample>>();
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> objectIds, SampleFetchOptions fetchOptions) {
        List<SamplePropertyRecord> records = this.loadSampleProperties(objectIds);
        HashSet<Long> propertyValues = new HashSet<Long>();
        for (SamplePropertyRecord record : records) {
            propertyValues.add(record.propertyValue);
        }
        Map samples = this.sampleTranslator.translate(context, propertyValues, fetchOptions);
        HashMap sampleProperties = new HashMap();
        for (SamplePropertyRecord record : records) {
            Sample sample;
            HashMap<String, Sample> properties = (HashMap<String, Sample>)sampleProperties.get(record.objectId);
            if (properties == null) {
                properties = new HashMap<String, Sample>();
                sampleProperties.put(record.objectId, properties);
            }
            if ((sample = (Sample)samples.get(record.propertyValue)) == null) continue;
            properties.put(record.propertyCode, sample);
        }
        return sampleProperties;
    }

    @Override
    protected void updateObject(TranslationContext context, Long objectId, ObjectHolder<Map<String, Sample>> result, Object relations, SampleFetchOptions fetchOptions) {
        Map sampleProperties = (Map)relations;
        HashMap objectProperties = (HashMap)sampleProperties.get(objectId);
        if (objectProperties == null) {
            objectProperties = new HashMap();
        }
        result.setObject(objectProperties);
    }

    protected abstract List<SamplePropertyRecord> loadSampleProperties(Collection<Long> var1);
}

