/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query;

import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.roleassignment.RoleAssignmentUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.QueryAuthorizationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.QueryQuery;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProviderAutoInitialized;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryAuthorizationValidator
implements IQueryAuthorizationValidator {
    @Autowired
    private IQueryDatabaseDefinitionProviderAutoInitialized databaseProvider;

    @Override
    public Set<Long> validate(PersonPE person, Collection<Long> queryIds) {
        boolean isInstanceAdmin = RoleAssignmentUtils.isInstanceAdmin(person);
        QueryQuery query = (QueryQuery)QueryTool.getManagedQuery(QueryQuery.class);
        List<QueryAuthorizationRecord> records = query.getAuthorizations((LongSet)new LongOpenHashSet(queryIds));
        HashSet<Long> result = new HashSet<Long>();
        for (QueryAuthorizationRecord record : records) {
            DatabaseDefinition database = this.databaseProvider.getDefinition(record.databaseKey);
            if (database == null || !record.isPublic && !record.registratorId.equals(person.getId()) && !isInstanceAdmin) continue;
            result.add(record.id);
        }
        return result;
    }
}

