/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryDatabase;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.fetchoptions.QueryDatabaseFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.Role;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleLevel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.query.IQueryDatabaseAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryDatabaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceTranslator;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryDatabaseTranslator
extends AbstractCachingTranslator<DatabaseDefinition, QueryDatabase, QueryDatabaseFetchOptions>
implements IQueryDatabaseTranslator {
    @Autowired
    private IQueryDatabaseAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISpaceTranslator spaceTranslator;

    @Override
    protected Object getObjectId(DatabaseDefinition input) {
        return input.getKey();
    }

    @Override
    protected boolean shouldTranslate(TranslationContext context, DatabaseDefinition input, QueryDatabaseFetchOptions fetchOptions) {
        try {
            this.authorizationExecutor.canRead(new OperationContext(context.getSession()), input.getKey());
            return true;
        }
        catch (AuthorizationFailureException e) {
            return false;
        }
    }

    @Override
    protected QueryDatabase createObject(TranslationContext context, DatabaseDefinition databaseDefinition, QueryDatabaseFetchOptions fetchOptions) {
        QueryDatabase database = new QueryDatabase();
        database.setFetchOptions(new QueryDatabaseFetchOptions());
        database.setPermId(new QueryDatabaseName(databaseDefinition.getKey()));
        database.setName(databaseDefinition.getKey());
        database.setLabel(databaseDefinition.getLabel());
        RoleWithHierarchy creatorMinimalRole = databaseDefinition.getCreatorMinimalRole();
        if (creatorMinimalRole != null) {
            database.setCreatorMinimalRole(Role.valueOf((String)creatorMinimalRole.getRoleCode().name()));
            database.setCreatorMinimalRoleLevel(RoleLevel.valueOf((String)creatorMinimalRole.getRoleLevel().name()));
        }
        return database;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<DatabaseDefinition> databaseDefinitions, QueryDatabaseFetchOptions fetchOptions) {
        HashMap relationsMap = new HashMap();
        if (fetchOptions.hasSpace()) {
            HashSet<Long> spaceIds = new HashSet<Long>();
            for (DatabaseDefinition databaseDefinition : databaseDefinitions) {
                if (databaseDefinition.tryGetDataSpace() == null) continue;
                spaceIds.add(databaseDefinition.tryGetDataSpace().getId());
            }
            Map spaceMap = this.spaceTranslator.translate(context, spaceIds, fetchOptions.withSpace());
            relationsMap.put(Space.class, spaceMap);
        }
        return relationsMap;
    }

    @Override
    protected void updateObject(TranslationContext context, DatabaseDefinition databaseDefinition, QueryDatabase result, Object objectRelations, QueryDatabaseFetchOptions fetchOptions) {
        Map relationsMap = (Map)objectRelations;
        if (fetchOptions.hasSpace()) {
            Map spaceMap = (Map)relationsMap.get(Space.class);
            if (databaseDefinition.tryGetDataSpace() != null) {
                result.setSpace((Space)spaceMap.get(databaseDefinition.tryGetDataSpace().getId()));
            }
            result.getFetchOptions().withSpaceUsing(fetchOptions.withSpace());
        }
    }
}

