/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.Query;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.QueryType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.fetchoptions.QueryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryDatabaseId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.IQueryId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryDatabaseName;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.query.id.QueryTechId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.IQueryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.query.QueryBaseRecord;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProvider;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryTranslator
extends AbstractCachingTranslator<Long, Query, QueryFetchOptions>
implements IQueryTranslator {
    @Autowired
    private IQueryAuthorizationValidator authorizationValidator;
    @Autowired
    private IQueryRegistratorTranslator registratorTranslator;
    @Autowired
    private IQueryBaseTranslator baseTranslator;
    @Autowired
    private IQueryDatabaseDefinitionProvider databaseProvider;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> queryIds, QueryFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), queryIds);
    }

    @Override
    protected Query createObject(TranslationContext context, Long queryId, QueryFetchOptions fetchOptions) {
        Query query = new Query();
        query.setFetchOptions(new QueryFetchOptions());
        return query;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> queryIds, QueryFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IQueryBaseTranslator.class, this.baseTranslator.translate(context, queryIds, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IQueryRegistratorTranslator.class, this.registratorTranslator.translate(context, queryIds, fetchOptions.withRegistrator()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long queryId, Query result, Object objectRelations, QueryFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        QueryBaseRecord baseRecord = (QueryBaseRecord)relations.get(IQueryBaseTranslator.class, queryId);
        result.setPermId((IQueryId)new QueryTechId(baseRecord.id));
        result.setName(baseRecord.name);
        result.setDescription(baseRecord.description);
        result.setDatabaseId((IQueryDatabaseId)new QueryDatabaseName(baseRecord.database));
        DatabaseDefinition database = this.databaseProvider.getDefinition(baseRecord.database);
        if (database != null) {
            result.setDatabaseLabel(database.getLabel());
        }
        result.setQueryType(QueryType.valueOf((String)baseRecord.queryType));
        result.setEntityTypeCodePattern(baseRecord.entityTypeCodePattern);
        result.setSql(baseRecord.sql);
        result.setPublic(baseRecord.isPublic);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IQueryRegistratorTranslator.class, queryId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
    }
}

