/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.AuthorizationGroup;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.Role;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.RoleLevel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.fetchoptions.RoleAssignmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.id.IRoleAssignmentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.id.RoleAssignmentTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.OperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IRoleAssignmentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentAuthorizationGroupTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentPersonTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentProjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentSpaceTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.IRoleAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.roleassignment.RoleAssignmentBaseRecord;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleAssignmentTranslator
extends AbstractCachingTranslator<Long, RoleAssignment, RoleAssignmentFetchOptions>
implements IRoleAssignmentTranslator {
    @Autowired
    private IRoleAssignmentAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IRoleAssignmentBaseTranslator baseTranslator;
    @Autowired
    private IRoleAssignmentRegistratorTranslator registratorTranslator;
    @Autowired
    private IRoleAssignmentPersonTranslator userTranslator;
    @Autowired
    private IRoleAssignmentAuthorizationGroupTranslator authorizationGroupTranslator;
    @Autowired
    private IRoleAssignmentSpaceTranslator spaceTranslator;
    @Autowired
    private IRoleAssignmentProjectTranslator projectTranslator;
    @Autowired
    private IAuthorizationConfig authorizationConfig;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> inputs, RoleAssignmentFetchOptions fetchOptions) {
        try {
            this.authorizationExecutor.canGet(new OperationContext(context.getSession()));
            return new HashSet<Long>(inputs);
        }
        catch (AuthorizationFailureException ex) {
            return new HashSet<Long>();
        }
    }

    @Override
    protected void filterTranslated(TranslationContext context, Map<Long, RoleAssignment> translated) {
        if (this.authorizationConfig.isProjectLevelEnabled()) {
            return;
        }
        HashSet<Long> projectRoleIds = new HashSet<Long>();
        for (Map.Entry<Long, RoleAssignment> entry : translated.entrySet()) {
            if (!RoleLevel.PROJECT.equals((Object)entry.getValue().getRoleLevel())) continue;
            projectRoleIds.add(entry.getKey());
        }
        for (Long projectRoleId : projectRoleIds) {
            translated.remove(projectRoleId);
        }
    }

    @Override
    protected RoleAssignment createObject(TranslationContext context, Long input, RoleAssignmentFetchOptions fetchOptions) {
        RoleAssignment roleAssignment = new RoleAssignment();
        roleAssignment.setFetchOptions(fetchOptions);
        return roleAssignment;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> inputs, RoleAssignmentFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IRoleAssignmentBaseTranslator.class, this.baseTranslator.translate(context, inputs, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IRoleAssignmentRegistratorTranslator.class, this.registratorTranslator.translate(context, inputs, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasUser()) {
            relations.put(IRoleAssignmentPersonTranslator.class, this.userTranslator.translate(context, inputs, fetchOptions.withUser()));
        }
        if (fetchOptions.hasAuthorizationGroup()) {
            relations.put(IRoleAssignmentAuthorizationGroupTranslator.class, this.authorizationGroupTranslator.translate(context, inputs, fetchOptions.withAuthorizationGroup()));
        }
        if (fetchOptions.hasSpace()) {
            relations.put(IRoleAssignmentSpaceTranslator.class, this.spaceTranslator.translate(context, inputs, fetchOptions.withSpace()));
        }
        if (fetchOptions.hasProject()) {
            relations.put(IRoleAssignmentProjectTranslator.class, this.projectTranslator.translate(context, inputs, fetchOptions.withProject()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long input, RoleAssignment output, Object objectRelations, RoleAssignmentFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        RoleAssignmentBaseRecord baseRecord = (RoleAssignmentBaseRecord)relations.get(IRoleAssignmentBaseTranslator.class, input);
        output.setId((IRoleAssignmentId)new RoleAssignmentTechId(baseRecord.id));
        output.setRole(Role.valueOf((String)baseRecord.role_code));
        output.setRoleLevel(this.extractRoleLevel(baseRecord));
        output.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasRegistrator()) {
            output.setRegistrator((Person)relations.get(IRoleAssignmentRegistratorTranslator.class, input));
            output.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasUser()) {
            output.setUser((Person)relations.get(IRoleAssignmentPersonTranslator.class, input));
            output.getFetchOptions().withUserUsing(fetchOptions.withUser());
        }
        if (fetchOptions.hasAuthorizationGroup()) {
            output.setAuthorizationGroup((AuthorizationGroup)relations.get(IRoleAssignmentAuthorizationGroupTranslator.class, input));
            output.getFetchOptions().withAuthorizationGroupUsing(fetchOptions.withAuthorizationGroup());
        }
        if (fetchOptions.hasSpace()) {
            output.setSpace((Space)relations.get(IRoleAssignmentSpaceTranslator.class, input));
            output.getFetchOptions().withSpaceUsing(fetchOptions.withSpace());
        }
        if (fetchOptions.hasProject()) {
            output.setProject((Project)relations.get(IRoleAssignmentProjectTranslator.class, input));
            output.getFetchOptions().withProjectUsing(fetchOptions.withProject());
        }
    }

    private RoleLevel extractRoleLevel(RoleAssignmentBaseRecord baseRecord) {
        if (baseRecord.space_id != null) {
            return RoleLevel.SPACE;
        }
        if (baseRecord.project_id != null) {
            return RoleLevel.PROJECT;
        }
        return RoleLevel.INSTANCE;
    }
}

