/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.IRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.RelationHistoryEntry;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.fetchoptions.HistoryEntryFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.history.id.UnknownRelatedObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.history.SampleRelationType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.project.IProjectAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceAuthorizationValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.QueryTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SampleHistoryTranslator
extends HistoryTranslator
implements ISampleHistoryTranslator {
    @Autowired
    private ISpaceAuthorizationValidator spaceValidator;
    @Autowired
    private IProjectAuthorizationValidator projectValidator;
    @Autowired
    private IExperimentAuthorizationValidator experimentValidator;
    @Autowired
    private ISampleAuthorizationValidator sampleValidator;
    @Autowired
    private IDataSetAuthorizationValidator dataSetValidator;

    @Override
    protected List<? extends PropertyRecord> loadProperties(Collection<Long> entityIds) {
        SampleQuery query = (SampleQuery)QueryTool.getManagedQuery(SampleQuery.class);
        return query.getProperties((LongSet)new LongOpenHashSet(entityIds));
    }

    protected List<HistoryPropertyRecord> loadPropertyHistory(Collection<Long> entityIds) {
        SampleQuery query = (SampleQuery)QueryTool.getManagedQuery(SampleQuery.class);
        return query.getPropertiesHistory((LongSet)new LongOpenHashSet(entityIds));
    }

    @Override
    protected List<? extends HistoryRelationshipRecord> loadRelationshipHistory(TranslationContext context, Collection<Long> entityIds) {
        SampleQuery query = (SampleQuery)QueryTool.getManagedQuery(SampleQuery.class);
        List<SampleRelationshipRecord> records = query.getRelationshipsHistory((LongSet)new LongOpenHashSet(entityIds));
        ArrayList<SampleRelationshipRecord> validRecords = new ArrayList<SampleRelationshipRecord>();
        Set<Long> spaceIds = new HashSet<Long>();
        Set<Long> projectIds = new HashSet<Long>();
        Set<Long> experimentIds = new HashSet<Long>();
        Set<Long> sampleIds = new HashSet<Long>();
        Set<Long> dataSetIds = new HashSet<Long>();
        for (SampleRelationshipRecord record : records) {
            if (record.spaceId != null) {
                spaceIds.add(record.spaceId);
                continue;
            }
            if (record.projectId != null) {
                projectIds.add(record.projectId);
                continue;
            }
            if (record.experimentId != null) {
                experimentIds.add(record.experimentId);
                continue;
            }
            if (record.sampleId != null) {
                sampleIds.add(record.sampleId);
                continue;
            }
            if (record.dataSetId == null) continue;
            dataSetIds.add(record.dataSetId);
        }
        if (!spaceIds.isEmpty()) {
            spaceIds = this.spaceValidator.validate(context.getSession().tryGetPerson(), spaceIds);
        }
        if (!projectIds.isEmpty()) {
            projectIds = this.projectValidator.validate(context.getSession().tryGetPerson(), projectIds);
        }
        if (!experimentIds.isEmpty()) {
            experimentIds = this.experimentValidator.validate(context.getSession().tryGetPerson(), experimentIds);
        }
        if (!sampleIds.isEmpty()) {
            sampleIds = this.sampleValidator.validate(context.getSession().tryGetPerson(), sampleIds);
        }
        if (!dataSetIds.isEmpty()) {
            dataSetIds = this.dataSetValidator.validate(context.getSession().tryGetPerson(), dataSetIds);
        }
        boolean isSystemUser = context.getSession().tryGetPerson() != null && context.getSession().tryGetPerson().isSystemUser();
        for (SampleRelationshipRecord record : records) {
            boolean isValid = false;
            isValid = record.spaceId != null ? spaceIds.contains(record.spaceId) : (record.projectId != null ? projectIds.contains(record.projectId) : (record.experimentId != null ? experimentIds.contains(record.experimentId) : (record.sampleId != null ? sampleIds.contains(record.sampleId) : (record.dataSetId != null ? dataSetIds.contains(record.dataSetId) : isSystemUser))));
            if (!isValid) continue;
            validRecords.add(record);
        }
        return validRecords;
    }

    @Override
    protected RelationHistoryEntry createRelationshipEntry(HistoryRelationshipRecord record, Map<Long, Person> authorMap, HistoryEntryFetchOptions fetchOptions) {
        RelationHistoryEntry entry = super.createRelationshipEntry(record, authorMap, fetchOptions);
        SampleRelationshipRecord sampleRecord = (SampleRelationshipRecord)record;
        if (this.isSpace(sampleRecord)) {
            entry.setRelationType((IRelationType)SampleRelationType.SPACE);
            entry.setRelatedObjectId((IObjectId)new SpacePermId(sampleRecord.relatedObjectId));
        } else if (this.isProject(sampleRecord)) {
            entry.setRelationType((IRelationType)SampleRelationType.PROJECT);
            entry.setRelatedObjectId((IObjectId)new ProjectPermId(sampleRecord.relatedObjectId));
        } else if (this.isExperiment(sampleRecord)) {
            entry.setRelationType((IRelationType)SampleRelationType.EXPERIMENT);
            entry.setRelatedObjectId((IObjectId)new ExperimentPermId(sampleRecord.relatedObjectId));
        } else if (this.isSample(sampleRecord)) {
            RelationType relationType = RelationType.valueOf(sampleRecord.relationType);
            switch (relationType) {
                case PARENT: {
                    entry.setRelationType((IRelationType)SampleRelationType.CHILD);
                    break;
                }
                case CHILD: {
                    entry.setRelationType((IRelationType)SampleRelationType.PARENT);
                    break;
                }
                case CONTAINER: {
                    entry.setRelationType((IRelationType)SampleRelationType.COMPONENT);
                    break;
                }
                case CONTAINED: 
                case COMPONENT: {
                    entry.setRelationType((IRelationType)SampleRelationType.CONTAINER);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported relation type: " + (Object)((Object)relationType));
                }
            }
            entry.setRelatedObjectId((IObjectId)new SamplePermId(sampleRecord.relatedObjectId));
        } else if (this.isDataSet(sampleRecord)) {
            entry.setRelationType((IRelationType)SampleRelationType.DATA_SET);
            entry.setRelatedObjectId((IObjectId)new DataSetPermId(sampleRecord.relatedObjectId));
        } else if (sampleRecord.relatedObjectId != null) {
            entry.setRelatedObjectId((IObjectId)new UnknownRelatedObjectId(sampleRecord.relatedObjectId, sampleRecord.relationType));
        }
        return entry;
    }
}

