/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectQuery;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.ObjectRelationRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.history.HistoryPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.MaterialPropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyAssignmentRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.PropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.property.SamplePropertyRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleRelationshipRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleTypeBaseRecord;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.lemnik.eodsql.Select;

public interface SampleQuery
extends ObjectQuery {
    @Select(sql="select s.id, s.code, s.perm_id as permId, sp.code as spaceCode, p.code as projectCode, sc.code as containerCode, s.registration_timestamp as registrationDate, s.modification_timestamp as modificationDate, s.frozen as frozen, s.frozen_for_comp as frozenForComponents, s.frozen_for_children as frozenForChildren, s.frozen_for_parents as frozenForParents, s.frozen_for_data as frozenForDataSets from samples s left join spaces sp on s.space_id = sp.id left join projects p on s.proj_id = p.id left join samples sc on s.samp_id_part_of = sc.id where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<SampleBaseRecord> getSamples(LongSet var1);

    @Select(sql="select s.id as objectId, s.saty_id as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getTypeIds(LongSet var1);

    @Select(sql="select st.id, st.code, st.description, st.is_listable as listable, st.is_subcode_unique as subcodeUnique, st.is_auto_generated_code as autoGeneratedCode, st.show_parent_metadata as showParentMetadata, st.generated_code_prefix as generatedCodePrefix, st.generated_from_depth as generatedFromDepth, st.part_of_depth as partOfDepth, st.modification_timestamp as modificationDate from sample_types st where st.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<SampleTypeBaseRecord> getTypes(LongSet var1);

    @Select(sql="select saty_id as objectId, id as relatedId from semantic_annotations where saty_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getTypeAnnotationIds(LongSet var1);

    @Select(sql="select p.id as id, p.samp_id as objectId, p.pers_id_author AS authorId, p.modification_timestamp AS modificationTimestamp, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.value as propertyValue, m.code as materialPropertyValueCode, mt.code as materialPropertyValueTypeCode, s.perm_id as sample_perm_id, s.id as sample_id, cvt.code as vocabularyPropertyValue, cv.code as vocabularyPropertyValueTypeCode from sample_properties p left join samples s on p.samp_prop_id = s.id left join materials m on p.mate_prop_id = m.id left join controlled_vocabulary_terms cvt on p.cvte_id = cvt.id left join controlled_vocabularies cv on cvt.covo_id = cv.id left join material_types mt on m.maty_id = mt.id join sample_type_property_types etpt on p.stpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<PropertyRecord> getProperties(LongSet var1);

    @Select(sql="select p.samp_id as objectId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.mate_prop_id as propertyValue from sample_properties p join sample_type_property_types etpt on p.stpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.mate_prop_id is not null and p.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MaterialPropertyRecord> getMaterialProperties(LongSet var1);

    @Select(sql="select p.samp_id as objectId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, p.samp_prop_id as propertyValue from sample_properties p join sample_type_property_types etpt on p.stpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where p.samp_prop_id is not null and p.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<SamplePropertyRecord> getSampleProperties(LongSet var1);

    @Select(sql="select ph.id as id, ph.samp_id as objectId, ph.pers_id_author as authorId, case pt.is_managed_internally when FALSE then pt.code else '$' || pt.code end as propertyCode, ph.value as propertyValue, ph.material as materialPropertyValue, ph.sample as samplePropertyValue, ph.vocabulary_term as vocabularyPropertyValue, ph.valid_from_timestamp as validFrom, ph.valid_until_timestamp as validTo from sample_properties_history ph join sample_type_property_types etpt on ph.stpt_id = etpt.id join property_types pt on etpt.prty_id = pt.id where ph.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<HistoryPropertyRecord> getPropertiesHistory(LongSet var1);

    @Select(sql="select srh.id as id, srh.main_samp_id as objectId, srh.pers_id_author as authorId, srh.relation_type as relationType, srh.entity_kind as entityKind, srh.entity_perm_id as relatedObjectId, srh.valid_from_timestamp as validFrom, srh.valid_until_timestamp as validTo, srh.space_id as spaceId, srh.proj_id as projectId, srh.expe_id as experimentId, srh.samp_id as sampleId, srh.data_id as dataSetId from sample_relationships_history srh where srh.main_samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<SampleRelationshipRecord> getRelationshipsHistory(LongSet var1);

    @Select(sql="select s.id as objectId, s.expe_id as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getExperimentIds(LongSet var1);

    @Select(sql="select s.id as objectId, s.samp_id_part_of as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getContainerIds(LongSet var1);

    @Select(sql="select s.samp_id_part_of as objectId, s.id as relatedId from samples s where s.samp_id_part_of = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getComponentsIds(LongSet var1);

    @Select(sql="select sr.sample_id_child as objectId, sr.sample_id_parent as relatedId, sr.child_annotations as annotations, sr.parent_annotations as relatedAnnotations from sample_relationships sr, relationship_types rt where sr.relationship_id = rt.id and rt.code = 'PARENT_CHILD' and sr.sample_id_child = any(?{1}) order by sr.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getParentIds(LongSet var1);

    @Select(sql="select sr.sample_id_parent as objectId, sr.sample_id_child as relatedId, sr.parent_annotations as annotations, sr.child_annotations as relatedAnnotations from sample_relationships sr, relationship_types rt where sr.relationship_id = rt.id and rt.code = 'PARENT_CHILD' and sr.sample_id_parent = any(?{1}) order by sr.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getChildIds(LongSet var1);

    @Select(sql="select s.id as objectId, s.pers_id_registerer as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getRegistratorIds(LongSet var1);

    @Select(sql="select s.id as objectId, s.pers_id_modifier as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getModifierIds(LongSet var1);

    @Select(sql="select ma.samp_id as objectId, ma.mepr_id as relatedId from metaproject_assignments ma where ma.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getTagIds(LongSet var1);

    @Select(sql="select d.samp_id as objectId, d.id as relatedId from data d where d.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getDataSetIds(LongSet var1);

    @Select(sql="select s.id as objectId, s.space_id as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getSpaceIds(LongSet var1);

    @Select(sql="select s.id as objectId, s.proj_id as relatedId from samples s where s.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getProjectIds(LongSet var1);

    @Select(sql="select saty_id as objectId, id as relatedId from sample_type_property_types where saty_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getPropertyAssignmentIds(LongSet var1);

    @Select(sql="select pt.code as prty_code, pt.is_managed_internally as prty_is_managed_internally, 'SAMPLE' as kind_code, st.id as type_id, st.code as type_code, stpt.* from sample_type_property_types stpt, property_types pt, sample_types st where stpt.id = any(?{1}) and stpt.prty_id = pt.id and stpt.saty_id = st.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<PropertyAssignmentRecord> getPropertyAssignments(LongSet var1);

    @Select(sql="select stpt_id as objectId, id as relatedId from semantic_annotations where stpt_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getPropertyAssignmentAnnotationIds(LongSet var1);

    @Select(sql="select t.id as objectId, t.validation_script_id as relatedId from sample_types t where t.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<ObjectRelationRecord> getValidationPluginIds(LongSet var1);
}

