/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.Relationship;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.CommonUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAttachmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleChildTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleComponentsTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleContainerTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleDataSetTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleHistoryTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleMaterialPropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleModifierTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleParentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleProjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISamplePropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleSamplePropertyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleSpaceTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTagTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeRelationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleBaseRecord;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleWithAnnotations;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SampleTranslator
extends AbstractCachingTranslator<Long, Sample, SampleFetchOptions>
implements ISampleTranslator {
    @Autowired
    private ISampleAuthorizationValidator authorizationValidator;
    @Autowired
    private ISampleBaseTranslator baseTranslator;
    @Autowired
    private ISampleTypeRelationTranslator typeTranslator;
    @Autowired
    private ISampleSpaceTranslator spaceTranslator;
    @Autowired
    private ISampleProjectTranslator projectTranslator;
    @Autowired
    private ISamplePropertyTranslator propertyTranslator;
    @Autowired
    private ISampleMaterialPropertyTranslator materialPropertyTranslator;
    @Autowired
    private ISampleSamplePropertyTranslator samplePropertyTranslator;
    @Autowired
    private ISampleExperimentTranslator experimentTranslator;
    @Autowired
    private ISampleParentTranslator parentTranslator;
    @Autowired
    private ISampleContainerTranslator containerTranslator;
    @Autowired
    private ISampleComponentsTranslator componentsTranslator;
    @Autowired
    private ISampleChildTranslator childTranslator;
    @Autowired
    private ISampleDataSetTranslator dataSetTranslator;
    @Autowired
    private ISampleTagTranslator tagTranslator;
    @Autowired
    private ISampleAttachmentTranslator attachmentTranslator;
    @Autowired
    private ISampleHistoryTranslator historyTranslator;
    @Autowired
    private ISampleRegistratorTranslator registratorTranslator;
    @Autowired
    private ISampleModifierTranslator modifierTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> sampleIds, SampleFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), sampleIds);
    }

    @Override
    protected Sample createObject(TranslationContext context, Long sampleId, SampleFetchOptions fetchOptions) {
        Sample sample = new Sample();
        sample.setFetchOptions(new SampleFetchOptions());
        return sample;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> sampleIds, SampleFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ISampleBaseTranslator.class, this.baseTranslator.translate(context, sampleIds, null));
        if (fetchOptions.hasType()) {
            relations.put(ISampleTypeRelationTranslator.class, this.typeTranslator.translate(context, sampleIds, fetchOptions.withType()));
        }
        if (fetchOptions.hasSpace()) {
            relations.put(ISampleSpaceTranslator.class, this.spaceTranslator.translate(context, sampleIds, fetchOptions.withSpace()));
        }
        if (fetchOptions.hasProject()) {
            relations.put(ISampleProjectTranslator.class, this.projectTranslator.translate(context, sampleIds, fetchOptions.withProject()));
        }
        if (fetchOptions.hasProperties()) {
            relations.put(ISamplePropertyTranslator.class, this.propertyTranslator.translate(context, sampleIds, fetchOptions.withProperties()));
        }
        if (fetchOptions.hasMaterialProperties()) {
            relations.put(ISampleMaterialPropertyTranslator.class, this.materialPropertyTranslator.translate(context, sampleIds, fetchOptions.withMaterialProperties()));
        }
        if (fetchOptions.hasSampleProperties()) {
            relations.put(ISampleSamplePropertyTranslator.class, this.samplePropertyTranslator.translate(context, sampleIds, fetchOptions.withSampleProperties()));
        }
        if (fetchOptions.hasExperiment()) {
            relations.put(ISampleExperimentTranslator.class, this.experimentTranslator.translate(context, sampleIds, fetchOptions.withExperiment()));
        }
        if (fetchOptions.hasContainer()) {
            relations.put(ISampleContainerTranslator.class, this.containerTranslator.translate(context, sampleIds, fetchOptions.withContainer()));
        }
        if (fetchOptions.hasComponents()) {
            relations.put(ISampleComponentsTranslator.class, this.componentsTranslator.translate(context, sampleIds, fetchOptions.withComponents()));
        }
        if (fetchOptions.hasParents()) {
            relations.put(ISampleParentTranslator.class, this.parentTranslator.translate(context, sampleIds, fetchOptions.withParents()));
        }
        if (fetchOptions.hasChildren()) {
            relations.put(ISampleChildTranslator.class, this.childTranslator.translate(context, sampleIds, fetchOptions.withChildren()));
        }
        if (fetchOptions.hasDataSets()) {
            relations.put(ISampleDataSetTranslator.class, this.dataSetTranslator.translate(context, sampleIds, fetchOptions.withDataSets()));
        }
        if (fetchOptions.hasTags()) {
            relations.put(ISampleTagTranslator.class, this.tagTranslator.translate(context, sampleIds, fetchOptions.withTags()));
        }
        if (fetchOptions.hasAttachments()) {
            relations.put(ISampleAttachmentTranslator.class, this.attachmentTranslator.translate(context, sampleIds, fetchOptions.withAttachments()));
        }
        if (fetchOptions.hasHistory()) {
            relations.put(ISampleHistoryTranslator.class, this.historyTranslator.translate(context, sampleIds, fetchOptions.withHistory()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(ISampleRegistratorTranslator.class, this.registratorTranslator.translate(context, sampleIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasModifier()) {
            relations.put(ISampleModifierTranslator.class, this.modifierTranslator.translate(context, sampleIds, fetchOptions.withModifier()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long sampleId, Sample result, Object objectRelations, SampleFetchOptions fetchOptions) {
        Relationship relationship;
        SamplePermId samplePermId;
        HashMap<SampleWithAnnotations, Relationship> relationships;
        Collection samples;
        TranslationResults relations = (TranslationResults)objectRelations;
        SampleBaseRecord baseRecord = (SampleBaseRecord)relations.get(ISampleBaseTranslator.class, sampleId);
        result.setPermId(new SamplePermId(baseRecord.permId));
        result.setCode(baseRecord.code);
        result.setIdentifier(new SampleIdentifier(baseRecord.spaceCode, baseRecord.projectCode, baseRecord.containerCode, baseRecord.code));
        result.setFrozen(baseRecord.frozen);
        result.setFrozenForComponents(baseRecord.frozenForComponents);
        result.setFrozenForChildren(baseRecord.frozenForChildren);
        result.setFrozenForParents(baseRecord.frozenForParents);
        result.setFrozenForDataSets(baseRecord.frozenForDataSets);
        result.setModificationDate(baseRecord.modificationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasType()) {
            result.setType((SampleType)relations.get(ISampleTypeRelationTranslator.class, sampleId));
            result.getFetchOptions().withTypeUsing(fetchOptions.withType());
        }
        if (fetchOptions.hasSpace()) {
            result.setSpace((Space)relations.get(ISampleSpaceTranslator.class, sampleId));
            result.getFetchOptions().withSpaceUsing(fetchOptions.withSpace());
        }
        if (fetchOptions.hasProject()) {
            result.setProject((Project)relations.get(ISampleProjectTranslator.class, sampleId));
            result.getFetchOptions().withProjectUsing(fetchOptions.withProject());
        }
        if (fetchOptions.hasProperties()) {
            result.setProperties((Map)relations.get(ISamplePropertyTranslator.class, sampleId));
            result.getFetchOptions().withPropertiesUsing(fetchOptions.withProperties());
        }
        if (fetchOptions.hasMaterialProperties()) {
            result.setMaterialProperties((Map)relations.get(ISampleMaterialPropertyTranslator.class, sampleId));
            result.getFetchOptions().withMaterialPropertiesUsing(fetchOptions.withMaterialProperties());
        }
        if (fetchOptions.hasSampleProperties()) {
            result.setSampleProperties((Map)relations.get(ISampleSamplePropertyTranslator.class, sampleId));
            result.getFetchOptions().withSamplePropertiesUsing(fetchOptions.withSampleProperties());
        }
        if (fetchOptions.hasExperiment()) {
            result.setExperiment((Experiment)relations.get(ISampleExperimentTranslator.class, sampleId));
            result.getFetchOptions().withExperimentUsing(fetchOptions.withExperiment());
        }
        if (fetchOptions.hasContainer()) {
            result.setContainer((Sample)relations.get(ISampleContainerTranslator.class, sampleId));
            result.getFetchOptions().withContainerUsing(fetchOptions.withContainer());
        }
        if (fetchOptions.hasComponents()) {
            result.setComponents(SampleUtils.extractSamples((Collection)relations.get(ISampleComponentsTranslator.class, sampleId)));
            result.getFetchOptions().withComponentsUsing(fetchOptions.withComponents());
        }
        if (fetchOptions.hasParents()) {
            samples = (Collection)relations.get(ISampleParentTranslator.class, sampleId);
            result.setParents(SampleUtils.extractSamples(samples));
            relationships = new HashMap<SampleWithAnnotations, Relationship>();
            for (SampleWithAnnotations sampleWithAnnotations : samples) {
                samplePermId = sampleWithAnnotations.getSample().getPermId();
                relationship = new Relationship();
                relationship.setChildAnnotations(CommonUtils.asMap(sampleWithAnnotations.getAnnotations(sampleId)));
                relationship.setParentAnnotations(CommonUtils.asMap(sampleWithAnnotations.getRelatedAnnotations(sampleId)));
                relationships.put(samplePermId == null ? sampleWithAnnotations : samplePermId, relationship);
            }
            result.setParentsRelationships(relationships);
            result.getFetchOptions().withParentsUsing(fetchOptions.withParents());
        }
        if (fetchOptions.hasChildren()) {
            samples = (Collection)relations.get(ISampleChildTranslator.class, sampleId);
            result.setChildren(SampleUtils.extractSamples(samples));
            relationships = new HashMap();
            for (SampleWithAnnotations sampleWithAnnotations : samples) {
                samplePermId = sampleWithAnnotations.getSample().getPermId();
                relationship = new Relationship();
                relationship.setParentAnnotations(CommonUtils.asMap(sampleWithAnnotations.getAnnotations(sampleId)));
                relationship.setChildAnnotations(CommonUtils.asMap(sampleWithAnnotations.getRelatedAnnotations(sampleId)));
                relationships.put(samplePermId == null ? sampleWithAnnotations : samplePermId, relationship);
            }
            result.setChildrenRelationships(relationships);
            result.getFetchOptions().withChildrenUsing(fetchOptions.withChildren());
        }
        if (fetchOptions.hasDataSets()) {
            result.setDataSets((List)relations.get(ISampleDataSetTranslator.class, sampleId));
            result.getFetchOptions().withDataSetsUsing(fetchOptions.withDataSets());
        }
        if (fetchOptions.hasTags()) {
            result.setTags((Set)relations.get(ISampleTagTranslator.class, sampleId));
            result.getFetchOptions().withTagsUsing(fetchOptions.withTags());
        }
        if (fetchOptions.hasAttachments()) {
            result.setAttachments((List)relations.get(ISampleAttachmentTranslator.class, sampleId));
            result.getFetchOptions().withAttachmentsUsing(fetchOptions.withAttachments());
        }
        if (fetchOptions.hasHistory()) {
            result.setHistory((List)relations.get(ISampleHistoryTranslator.class, sampleId));
            result.getFetchOptions().withHistoryUsing(fetchOptions.withHistory());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(ISampleRegistratorTranslator.class, sampleId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasModifier()) {
            result.setModifier((Person)relations.get(ISampleModifierTranslator.class, sampleId));
            result.getFetchOptions().withModifierUsing(fetchOptions.withModifier());
        }
    }

    @Override
    protected void postTranslate(TranslationContext context, Map<Long, Sample> samplesByIds) {
        HashSet<Sample> visitedSamples = new HashSet<Sample>();
        for (Sample sample : samplesByIds.values()) {
            this.postTranslate(sample, visitedSamples);
        }
    }

    private void postTranslate(Sample sample, Set<Sample> visitedSamples) {
        if (!visitedSamples.contains(sample)) {
            visitedSamples.add(sample);
            if (sample.getFetchOptions().hasParents()) {
                this.replaceRelationshipPlaceholders(sample.getParentsRelationships());
                for (Sample parent : sample.getParents()) {
                    this.postTranslate(parent, visitedSamples);
                }
            }
            if (sample.getFetchOptions().hasChildren()) {
                this.replaceRelationshipPlaceholders(sample.getChildrenRelationships());
                for (Sample child : sample.getChildren()) {
                    this.postTranslate(child, visitedSamples);
                }
            }
        }
    }

    private void replaceRelationshipPlaceholders(Map<SamplePermId, Relationship> relationships) {
        if (relationships != null) {
            for (SamplePermId samplePermId : new HashSet<SamplePermId>(relationships.keySet())) {
                SampleWithAnnotations sampleWithAnnotations;
                SamplePermId permId;
                if (!(samplePermId instanceof SampleWithAnnotations) || (permId = (sampleWithAnnotations = (SampleWithAnnotations)samplePermId).getSample().getPermId()) == null) continue;
                relationships.put(permId, relationships.remove((Object)sampleWithAnnotations));
            }
        }
    }
}

