/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.Plugin;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sort.SortAndPage;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISamplePropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeSemanticAnnotationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleTypeValidationPluginTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.SampleTypeBaseRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SampleTypeTranslator
extends AbstractCachingTranslator<Long, SampleType, SampleTypeFetchOptions>
implements ISampleTypeTranslator {
    @Autowired
    private ISampleTypeBaseTranslator baseTranslator;
    @Autowired
    private ISamplePropertyAssignmentTranslator assignmentTranslator;
    @Autowired
    private ISampleTypeValidationPluginTranslator validationPluginTranslator;
    @Autowired
    private ISampleTypeSemanticAnnotationTranslator annotationTranslator;

    @Override
    protected SampleType createObject(TranslationContext context, Long typeId, SampleTypeFetchOptions fetchOptions) {
        SampleType type = new SampleType();
        type.setFetchOptions(fetchOptions);
        return type;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> typeIds, SampleTypeFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ISampleTypeBaseTranslator.class, this.baseTranslator.translate(context, typeIds, null));
        if (fetchOptions.hasPropertyAssignments()) {
            relations.put(ISamplePropertyAssignmentTranslator.class, this.assignmentTranslator.translate(context, typeIds, fetchOptions.withPropertyAssignments()));
        }
        if (fetchOptions.hasValidationPlugin()) {
            relations.put(ISampleTypeValidationPluginTranslator.class, this.validationPluginTranslator.translate(context, typeIds, fetchOptions.withValidationPlugin()));
        }
        if (fetchOptions.hasSemanticAnnotations()) {
            relations.put(ISampleTypeSemanticAnnotationTranslator.class, this.annotationTranslator.translate(context, typeIds, fetchOptions.withSemanticAnnotations()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long typeId, SampleType result, Object objectRelations, SampleTypeFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        SampleTypeBaseRecord baseRecord = (SampleTypeBaseRecord)relations.get(ISampleTypeBaseTranslator.class, typeId);
        result.setPermId(new EntityTypePermId(baseRecord.code, EntityKind.SAMPLE));
        result.setCode(baseRecord.code);
        result.setDescription(baseRecord.description);
        result.setAutoGeneratedCode(Boolean.valueOf(baseRecord.autoGeneratedCode));
        result.setGeneratedCodePrefix(baseRecord.generatedCodePrefix);
        result.setListable(Boolean.valueOf(baseRecord.listable));
        result.setShowContainer(Boolean.valueOf(baseRecord.partOfDepth > 0));
        result.setShowParents(Boolean.valueOf(baseRecord.generatedFromDepth > 0));
        result.setShowParentMetadata(Boolean.valueOf(baseRecord.showParentMetadata));
        result.setSubcodeUnique(Boolean.valueOf(baseRecord.subcodeUnique));
        result.setModificationDate(baseRecord.modificationDate);
        if (fetchOptions.hasPropertyAssignments()) {
            Collection assignments = (Collection)relations.get(ISamplePropertyAssignmentTranslator.class, typeId);
            ArrayList propertyAssignments = new ArrayList(assignments);
            result.setPropertyAssignments((List)new SortAndPage().sortAndPage(propertyAssignments, null, (FetchOptions)fetchOptions.withPropertyAssignments()));
        }
        if (fetchOptions.hasValidationPlugin()) {
            result.setValidationPlugin((Plugin)relations.get(ISampleTypeValidationPluginTranslator.class, typeId));
        }
        if (fetchOptions.hasSemanticAnnotations()) {
            result.setSemanticAnnotations((List)relations.get(ISampleTypeSemanticAnnotationTranslator.class, typeId));
            result.getFetchOptions().withSemanticAnnotationsUsing(fetchOptions.withSemanticAnnotations());
        }
    }
}

