/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.AbstractSampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.NoSampleContainerSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.NoSampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleChildrenSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleContainerSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleParentsSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractCompositeSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchObjectKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AssociatedEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;

public class SampleSearchCriteriaTranslator
extends AbstractCompositeSearchCriteriaTranslator {
    public SampleSearchCriteriaTranslator(IDAOFactory idaoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(idaoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof AbstractSampleSearchCriteria || criteria instanceof NoSampleSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        AssociatedEntityKind entityKind;
        if (criteria instanceof NoSampleSearchCriteria) {
            AssociatedEntityKind entityKind2 = criteria instanceof NoSampleContainerSearchCriteria ? AssociatedEntityKind.SAMPLE_CONTAINER : AssociatedEntityKind.SAMPLE;
            return new SearchCriteriaTranslationResult(new DetailedSearchSubCriteria(entityKind2, null));
        }
        context.pushObjectKind(SearchObjectKind.SAMPLE);
        SearchCriteriaTranslationResult translationResult = super.doTranslate(context, criteria);
        context.popObjectKind();
        if (criteria instanceof SampleSearchCriteria && context.peekObjectKind() == null) {
            return translationResult;
        }
        if (criteria instanceof SampleParentsSearchCriteria) {
            entityKind = AssociatedEntityKind.SAMPLE_PARENT;
        } else if (criteria instanceof SampleChildrenSearchCriteria) {
            entityKind = AssociatedEntityKind.SAMPLE_CHILD;
        } else if (criteria instanceof SampleContainerSearchCriteria) {
            entityKind = AssociatedEntityKind.SAMPLE_CONTAINER;
        } else if (criteria instanceof SampleSearchCriteria) {
            entityKind = AssociatedEntityKind.SAMPLE;
        } else {
            throw new IllegalArgumentException("Unknown criteria: " + criteria);
        }
        DetailedSearchSubCriteria subCriteria = new DetailedSearchSubCriteria(entityKind, translationResult.getCriteria());
        return new SearchCriteriaTranslationResult(subCriteria);
    }
}

