/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IEntityType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.fetchoptions.SemanticAnnotationFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.SemanticAnnotationPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationEntityTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationPropertyAssignmentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationPropertyTypeTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.ISemanticAnnotationTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.semanticannotation.SemanticAnnotationBaseRecord;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SemanticAnnotationTranslator
extends AbstractCachingTranslator<Long, SemanticAnnotation, SemanticAnnotationFetchOptions>
implements ISemanticAnnotationTranslator {
    @Autowired
    private ISemanticAnnotationEntityTypeTranslator entityTypeTranslator;
    @Autowired
    private ISemanticAnnotationPropertyTypeTranslator propertyTypeTranslator;
    @Autowired
    private ISemanticAnnotationPropertyAssignmentTranslator propertyAssignmentTranslator;
    @Autowired
    private ISemanticAnnotationBaseTranslator baseTranslator;

    @Override
    protected SemanticAnnotation createObject(TranslationContext context, Long annotationId, SemanticAnnotationFetchOptions fetchOptions) {
        SemanticAnnotation annotation = new SemanticAnnotation();
        annotation.setFetchOptions(new SemanticAnnotationFetchOptions());
        return annotation;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> annotationIds, SemanticAnnotationFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ISemanticAnnotationBaseTranslator.class, this.baseTranslator.translate(context, annotationIds, null));
        if (fetchOptions.hasEntityType()) {
            relations.put(ISemanticAnnotationEntityTypeTranslator.class, this.entityTypeTranslator.translate(context, annotationIds, fetchOptions.withEntityType()));
        }
        if (fetchOptions.hasPropertyType()) {
            relations.put(ISemanticAnnotationPropertyTypeTranslator.class, this.propertyTypeTranslator.translate(context, annotationIds, fetchOptions.withPropertyType()));
        }
        if (fetchOptions.hasPropertyAssignment()) {
            relations.put(ISemanticAnnotationPropertyAssignmentTranslator.class, this.propertyAssignmentTranslator.translate(context, annotationIds, fetchOptions.withPropertyAssignment()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long annotationId, SemanticAnnotation result, Object objectRelations, SemanticAnnotationFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        SemanticAnnotationBaseRecord baseRecord = (SemanticAnnotationBaseRecord)relations.get(ISemanticAnnotationBaseTranslator.class, annotationId);
        result.setPermId(new SemanticAnnotationPermId(baseRecord.permId));
        result.setPredicateOntologyId(baseRecord.predicateOntologyId);
        result.setPredicateOntologyVersion(baseRecord.predicateOntologyVersion);
        result.setPredicateAccessionId(baseRecord.predicateAccessionId);
        result.setDescriptorOntologyId(baseRecord.descriptorOntologyId);
        result.setDescriptorOntologyVersion(baseRecord.descriptorOntologyVersion);
        result.setDescriptorAccessionId(baseRecord.descriptorAccessionId);
        result.setCreationDate(baseRecord.creationDate);
        if (fetchOptions.hasEntityType()) {
            result.setEntityType((IEntityType)relations.get(ISemanticAnnotationEntityTypeTranslator.class, annotationId));
            result.getFetchOptions().withEntityTypeUsing(fetchOptions.withEntityType());
        }
        if (fetchOptions.hasPropertyType()) {
            result.setPropertyType((PropertyType)relations.get(ISemanticAnnotationPropertyTypeTranslator.class, annotationId));
            result.getFetchOptions().withPropertyTypeUsing(fetchOptions.withPropertyType());
        }
        if (fetchOptions.hasPropertyAssignment()) {
            result.setPropertyAssignment((PropertyAssignment)relations.get(ISemanticAnnotationPropertyAssignmentTranslator.class, annotationId));
            result.getFetchOptions().withPropertyAssignmentUsing(fetchOptions.withPropertyAssignment());
        }
    }
}

