/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpaceTechId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceProjectTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceSampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.ISpaceTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.SpaceBaseRecord;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceTranslator
extends AbstractCachingTranslator<Long, Space, SpaceFetchOptions>
implements ISpaceTranslator {
    @Autowired
    private ISpaceAuthorizationValidator authorizationValidator;
    @Autowired
    private ISpaceRegistratorTranslator registratorTranslator;
    @Autowired
    private ISpaceProjectTranslator projectTranslator;
    @Autowired
    private ISpaceSampleTranslator sampleTranslator;
    @Autowired
    private ISpaceBaseTranslator baseTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> spaceIds, SpaceFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), spaceIds);
    }

    @Override
    protected Space createObject(TranslationContext context, Long spaceId, SpaceFetchOptions fetchOptions) {
        Space space = new Space();
        space.setFetchOptions(new SpaceFetchOptions());
        return space;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> spaceIds, SpaceFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ISpaceBaseTranslator.class, this.baseTranslator.translate(context, spaceIds, null));
        if (fetchOptions.hasProjects()) {
            relations.put(ISpaceProjectTranslator.class, this.projectTranslator.translate(context, spaceIds, fetchOptions.withProjects()));
        }
        if (fetchOptions.hasSamples()) {
            relations.put(ISpaceSampleTranslator.class, this.sampleTranslator.translate(context, spaceIds, fetchOptions.withSamples()));
        }
        if (fetchOptions.hasRegistrator()) {
            relations.put(ISpaceRegistratorTranslator.class, this.registratorTranslator.translate(context, spaceIds, fetchOptions.withRegistrator()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long spaceId, Space result, Object objectRelations, SpaceFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        SpaceBaseRecord baseRecord = (SpaceBaseRecord)relations.get(ISpaceBaseTranslator.class, spaceId);
        result.setId(new SpaceTechId(baseRecord.id));
        result.setCode(baseRecord.code);
        result.setPermId(new SpacePermId(baseRecord.code));
        result.setDescription(baseRecord.description);
        result.setFrozen(baseRecord.frozen);
        result.setFrozenForProjects(baseRecord.frozenForProjects);
        result.setFrozenForSamples(baseRecord.frozenForSamples);
        result.setModificationDate(baseRecord.registrationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasProjects()) {
            result.setProjects((List)relations.get(ISpaceProjectTranslator.class, spaceId));
            result.getFetchOptions().withProjectsUsing(fetchOptions.withProjects());
        }
        if (fetchOptions.hasSamples()) {
            result.setSamples(SampleUtils.extractSamples((Collection)relations.get(ISpaceSampleTranslator.class, spaceId)));
            result.getFetchOptions().withSamplesUsing(fetchOptions.withSamples());
        }
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(ISpaceRegistratorTranslator.class, spaceId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
    }
}

