/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.space.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.NoSpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldFromCompositeSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchCriteriaTranslationResult;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchObjectKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SimpleAttributeSearchFieldKind;
import java.util.EnumSet;

public class SpaceSearchCriteriaTranslator
extends AbstractFieldFromCompositeSearchCriteriaTranslator {
    private static final DetailedSearchField SPACE_ID_FIELD = DetailedSearchField.createAttributeField(new SimpleAttributeSearchFieldKind("sample space id", "Space ID"));
    private static final EnumSet<SearchObjectKind> ENTITY_KINDS_WITH_SPACE = EnumSet.of(SearchObjectKind.EXPERIMENT, SearchObjectKind.SAMPLE);

    public SpaceSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof NoSpaceSearchCriteria || criteria instanceof SpaceSearchCriteria;
    }

    @Override
    protected SearchCriteriaTranslationResult doTranslate(SearchTranslationContext context, ISearchCriteria criteria) {
        SearchObjectKind peekObjectKind = context.peekObjectKind();
        if (!ENTITY_KINDS_WITH_SPACE.contains((Object)peekObjectKind)) {
            throw new IllegalArgumentException("Space criteria can be used only in experiment and sample criteria, but was used in: " + (Object)((Object)peekObjectKind) + " context.");
        }
        if (criteria instanceof NoSpaceSearchCriteria) {
            if (!SearchObjectKind.SAMPLE.equals((Object)peekObjectKind)) {
                throw new IllegalArgumentException("No space criteria can be used only in sample search criteria, but was used in: " + (Object)((Object)peekObjectKind) + " context.");
            }
            return new SearchCriteriaTranslationResult(new DetailedSearchCriterion(SPACE_ID_FIELD, "NULL"));
        }
        return super.doTranslate(context, criteria);
    }

    @Override
    protected DetailedSearchField doTranslateSearchField(SearchTranslationContext context, ISearchCriteria criteria, ISearchCriteria subCriteria) {
        SearchObjectKind objectKind = context.peekObjectKind();
        if (SearchObjectKind.EXPERIMENT.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(ExperimentAttributeSearchFieldKind.PROJECT_SPACE);
        }
        if (SearchObjectKind.SAMPLE.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(SampleAttributeSearchFieldKind.SPACE);
        }
        throw new IllegalArgumentException("Unknown object kind: " + (Object)((Object)objectKind));
    }
}

