/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.Tag;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.fetchoptions.TagFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.SampleUtils;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagDataSetTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagExperimentTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagMaterialTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagOwnerTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagSampleTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.ITagTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.TagBaseRecord;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagTranslator
extends AbstractCachingTranslator<Long, Tag, TagFetchOptions>
implements ITagTranslator {
    @Autowired
    private ITagAuthorizationValidator authorizationValidator;
    @Autowired
    private ITagBaseTranslator baseTranslator;
    @Autowired
    private ITagOwnerTranslator ownerTranslator;
    @Autowired
    private ITagExperimentTranslator experimentTranslator;
    @Autowired
    private ITagSampleTranslator sampleTranslator;
    @Autowired
    private ITagDataSetTranslator dataSetTranslator;
    @Autowired
    private ITagMaterialTranslator materialTranslator;

    @Override
    protected Set<Long> shouldTranslate(TranslationContext context, Collection<Long> tagIds, TagFetchOptions fetchOptions) {
        return this.authorizationValidator.validate(context.getSession().tryGetPerson(), tagIds);
    }

    @Override
    protected Tag createObject(TranslationContext context, Long tagId, TagFetchOptions fetchOptions) {
        Tag result = new Tag();
        result.setFetchOptions(new TagFetchOptions());
        return result;
    }

    protected TranslationResults getObjectsRelations(TranslationContext context, Collection<Long> tagIds, TagFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(ITagBaseTranslator.class, this.baseTranslator.translate(context, tagIds, null));
        if (fetchOptions.hasOwner()) {
            relations.put(ITagOwnerTranslator.class, this.ownerTranslator.translate(context, tagIds, fetchOptions.withOwner()));
        }
        if (fetchOptions.hasExperiments()) {
            relations.put(ITagExperimentTranslator.class, this.experimentTranslator.translate(context, tagIds, fetchOptions.withExperiments()));
        }
        if (fetchOptions.hasSamples()) {
            relations.put(ITagSampleTranslator.class, this.sampleTranslator.translate(context, tagIds, fetchOptions.withSamples()));
        }
        if (fetchOptions.hasDataSets()) {
            relations.put(ITagDataSetTranslator.class, this.dataSetTranslator.translate(context, tagIds, fetchOptions.withDataSets()));
        }
        if (fetchOptions.hasMaterials()) {
            relations.put(ITagMaterialTranslator.class, this.materialTranslator.translate(context, tagIds, fetchOptions.withMaterials()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long tagId, Tag result, Object objectRelations, TagFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        TagBaseRecord baseRecord = (TagBaseRecord)relations.get(ITagBaseTranslator.class, tagId);
        result.setPermId(new TagPermId(baseRecord.owner, baseRecord.name));
        result.setCode(baseRecord.name);
        result.setDescription(baseRecord.description);
        result.setPrivate(baseRecord.isPrivate);
        result.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasOwner()) {
            result.setOwner((Person)relations.get(ITagOwnerTranslator.class, tagId));
            result.getFetchOptions().withOwnerUsing(fetchOptions.withOwner());
        }
        if (fetchOptions.hasExperiments()) {
            result.setExperiments((List)relations.get(ITagExperimentTranslator.class, tagId));
            result.getFetchOptions().withExperimentsUsing(fetchOptions.withExperiments());
        }
        if (fetchOptions.hasSamples()) {
            result.setSamples(SampleUtils.extractSamples((Collection)relations.get(ITagSampleTranslator.class, tagId)));
            result.getFetchOptions().withSamplesUsing(fetchOptions.withSamples());
        }
        if (fetchOptions.hasDataSets()) {
            result.setDataSets((List)relations.get(ITagDataSetTranslator.class, tagId));
            result.getFetchOptions().withDataSetsUsing(fetchOptions.withDataSets());
        }
        if (fetchOptions.hasMaterials()) {
            result.setMaterials((List)relations.get(ITagMaterialTranslator.class, tagId));
            result.getFetchOptions().withMaterialsUsing(fetchOptions.withMaterials());
        }
    }
}

