/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.tag.search;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.search.TagSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.AbstractFieldFromCompositeSearchCriteriaTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.IObjectAttributeProviderFactory;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchObjectKind;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.search.SearchTranslationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;

public class TagSearchCriteriaTranslator
extends AbstractFieldFromCompositeSearchCriteriaTranslator {
    public TagSearchCriteriaTranslator(IDAOFactory daoFactory, IObjectAttributeProviderFactory entityAttributeProviderFactory) {
        super(daoFactory, entityAttributeProviderFactory);
    }

    @Override
    protected boolean doAccepts(ISearchCriteria criteria) {
        return criteria instanceof TagSearchCriteria;
    }

    @Override
    protected DetailedSearchField doTranslateSearchField(SearchTranslationContext context, ISearchCriteria criteria, ISearchCriteria subCriteria) {
        SearchObjectKind objectKind = context.peekObjectKind();
        if (SearchObjectKind.EXPERIMENT.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(ExperimentAttributeSearchFieldKind.METAPROJECT);
        }
        if (SearchObjectKind.SAMPLE.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(SampleAttributeSearchFieldKind.METAPROJECT);
        }
        if (SearchObjectKind.DATA_SET.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(DataSetAttributeSearchFieldKind.METAPROJECT);
        }
        if (SearchObjectKind.MATERIAL.equals((Object)objectKind)) {
            return DetailedSearchField.createAttributeField(MaterialAttributeSearchFieldKind.METAPROJECT);
        }
        throw new IllegalArgumentException("Unknown object kind: " + (Object)((Object)objectKind));
    }
}

