/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.VocabularyTerm;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyTermFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyTermPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTermBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTermRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTermTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTermVocabularyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.VocabularyTermBaseRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VocabularyTermTranslator
extends AbstractCachingTranslator<Long, VocabularyTerm, VocabularyTermFetchOptions>
implements IVocabularyTermTranslator {
    @Autowired
    private IVocabularyTermBaseTranslator baseTranslator;
    @Autowired
    private IVocabularyTermRegistratorTranslator registratorTranslator;
    @Autowired
    private IVocabularyTermVocabularyTranslator vocabularyTranslator;

    @Override
    protected VocabularyTerm createObject(TranslationContext context, Long termId, VocabularyTermFetchOptions fetchOptions) {
        VocabularyTerm term = new VocabularyTerm();
        term.setFetchOptions(new VocabularyTermFetchOptions());
        return term;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> termIds, VocabularyTermFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IVocabularyTermBaseTranslator.class, this.baseTranslator.translate(context, termIds, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IVocabularyTermRegistratorTranslator.class, this.registratorTranslator.translate(context, termIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasVocabulary()) {
            relations.put(IVocabularyTermVocabularyTranslator.class, this.vocabularyTranslator.translate(context, termIds, fetchOptions.withVocabulary()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long termId, VocabularyTerm result, Object objectRelations, VocabularyTermFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        VocabularyTermBaseRecord baseRecord = (VocabularyTermBaseRecord)relations.get(IVocabularyTermBaseTranslator.class, termId);
        result.setPermId(new VocabularyTermPermId(baseRecord.code, CodeConverter.tryToBusinessLayer(baseRecord.vocabularyCode, baseRecord.isManagedInternally)));
        result.setCode(baseRecord.code);
        result.setLabel(baseRecord.label);
        result.setDescription(baseRecord.description);
        result.setOrdinal(baseRecord.ordinal);
        result.setOfficial(baseRecord.isOfficial);
        result.setModificationDate(baseRecord.registrationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IVocabularyTermRegistratorTranslator.class, termId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasVocabulary()) {
            result.setVocabulary((Vocabulary)relations.get(IVocabularyTermVocabularyTranslator.class, termId));
            result.getFetchOptions().withVocabularyUsing(fetchOptions.withVocabulary());
        }
    }
}

