/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.Vocabulary;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.fetchoptions.VocabularyFetchOptions;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.AbstractCachingTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.TranslationResults;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyBaseTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyRegistratorTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.IVocabularyVocabularyTermTranslator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.vocabulary.VocabularyBaseRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VocabularyTranslator
extends AbstractCachingTranslator<Long, Vocabulary, VocabularyFetchOptions>
implements IVocabularyTranslator {
    @Autowired
    private IVocabularyBaseTranslator baseTranslator;
    @Autowired
    private IVocabularyRegistratorTranslator registratorTranslator;
    @Autowired
    private IVocabularyVocabularyTermTranslator termTranslator;

    @Override
    protected Vocabulary createObject(TranslationContext context, Long vocabularyId, VocabularyFetchOptions fetchOptions) {
        Vocabulary vocabulary = new Vocabulary();
        vocabulary.setFetchOptions(new VocabularyFetchOptions());
        return vocabulary;
    }

    @Override
    protected Object getObjectsRelations(TranslationContext context, Collection<Long> vocabularyIds, VocabularyFetchOptions fetchOptions) {
        TranslationResults relations = new TranslationResults();
        relations.put(IVocabularyBaseTranslator.class, this.baseTranslator.translate(context, vocabularyIds, null));
        if (fetchOptions.hasRegistrator()) {
            relations.put(IVocabularyRegistratorTranslator.class, this.registratorTranslator.translate(context, vocabularyIds, fetchOptions.withRegistrator()));
        }
        if (fetchOptions.hasTerms()) {
            relations.put(IVocabularyVocabularyTermTranslator.class, this.termTranslator.translate(context, vocabularyIds, fetchOptions.withTerms()));
        }
        return relations;
    }

    @Override
    protected void updateObject(TranslationContext context, Long vocabularyId, Vocabulary result, Object objectRelations, VocabularyFetchOptions fetchOptions) {
        TranslationResults relations = (TranslationResults)objectRelations;
        VocabularyBaseRecord baseRecord = (VocabularyBaseRecord)relations.get(IVocabularyBaseTranslator.class, vocabularyId);
        result.setCode(CodeConverter.tryToBusinessLayer(baseRecord.code, baseRecord.isManagedInternally));
        result.setDescription(baseRecord.description);
        result.setModificationDate(baseRecord.modificationDate);
        result.setRegistrationDate(baseRecord.registrationDate);
        result.setManagedInternally(baseRecord.isManagedInternally);
        result.setChosenFromList(baseRecord.isChosenFromList);
        result.setUrlTemplate(baseRecord.urlTemplate);
        if (fetchOptions.hasRegistrator()) {
            result.setRegistrator((Person)relations.get(IVocabularyRegistratorTranslator.class, vocabularyId));
            result.getFetchOptions().withRegistratorUsing(fetchOptions.withRegistrator());
        }
        if (fetchOptions.hasTerms()) {
            result.setTerms((List)relations.get(IVocabularyVocabularyTermTranslator.class, vocabularyId));
            result.getFetchOptions().withTermsUsing(fetchOptions.withTerms());
        }
    }
}

