/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.xls.export;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.vocabulary.id.VocabularyPermId;
import ch.ethz.sis.openbis.generic.server.xls.export.ExportablePermId;
import ch.ethz.sis.openbis.generic.server.xls.export.helper.IXLSExportHelper;
import ch.ethz.sis.openbis.generic.server.xls.export.helper.XLSSampleTypeExportHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSExport {
    private final IXLSExportHelper sampleTypeExportHelper = new XLSSampleTypeExportHelper();

    public OutputStream export(IApplicationServerApi api, Collection<ExportablePermId> exportablePermIds, boolean exportReferred) throws IOException {
        if (!this.isValid(exportablePermIds)) {
            throw new IllegalArgumentException();
        }
        if (exportReferred) {
            exportablePermIds = this.expandReference(api, exportablePermIds);
        }
        exportablePermIds = this.sort(exportablePermIds);
        XSSFWorkbook wb = new XSSFWorkbook();
        for (ExportablePermId exportablePermId : exportablePermIds) {
            switch (exportablePermId.getExportableKind()) {
                case SAMPLE_TYPE: {
                    this.sampleTypeExportHelper.add(api, (Workbook)wb, exportablePermId);
                    break;
                }
                case EXPERIMENT_TYPE: {
                    break;
                }
                case DATASET_TYPE: {
                    break;
                }
                case VOCABULARY: {
                    break;
                }
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        wb.write((OutputStream)result);
        return result;
    }

    private Collection<ExportablePermId> expandReference(IApplicationServerApi api, Collection<ExportablePermId> exportablePermIds) {
        return exportablePermIds;
    }

    private Collection<ExportablePermId> sort(Collection<ExportablePermId> exportablePermIds) {
        return exportablePermIds;
    }

    private boolean isValid(Collection<ExportablePermId> exportablePermIds) {
        boolean isValid = true;
        for (ExportablePermId exportablePermId : exportablePermIds) {
            switch (exportablePermId.getExportableKind()) {
                case SAMPLE_TYPE: {
                    isValid = exportablePermId.getPermId() instanceof EntityTypePermId && ((EntityTypePermId)exportablePermId.getPermId()).getEntityKind() == EntityKind.SAMPLE;
                    break;
                }
                case EXPERIMENT_TYPE: {
                    isValid = exportablePermId.getPermId() instanceof EntityTypePermId && ((EntityTypePermId)exportablePermId.getPermId()).getEntityKind() == EntityKind.EXPERIMENT;
                    break;
                }
                case DATASET_TYPE: {
                    isValid = exportablePermId.getPermId() instanceof EntityTypePermId && ((EntityTypePermId)exportablePermId.getPermId()).getEntityKind() == EntityKind.DATA_SET;
                    break;
                }
                case VOCABULARY: {
                    isValid = exportablePermId.getPermId() instanceof VocabularyPermId;
                    break;
                }
                case PROPERTY_TYPE: {
                    isValid = exportablePermId.getPermId() instanceof PropertyTypePermId;
                }
            }
            if (isValid) continue;
            break;
        }
        return isValid;
    }
}

